% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicHelpChiIndexConcept.R
\name{drawPublicHelpChiIndex}
\alias{drawPublicHelpChiIndex}
\title{Draw Public Help index Chi for 3 or 4 players}
\usage{
drawPublicHelpChiIndex(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "Public Help Chi Index")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawPublicHelpChiIndex draws the Public Help index Chi for a simple game with 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
drawPublicHelpChiIndex(v) 
}
\references{
Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25

Stach I. (2016) "Power Measures and Public Goods", In: Nguyen, N.T. and Kowalczyk, R. (Eds.): Transactions on Computational Collective Intelligence XXIII, Springer, pp. 99--110
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
