% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BanzhafConcept.R
\name{nonNormalizedBanzhafIndex}
\alias{nonNormalizedBanzhafIndex}
\title{Compute non-normalized Banzhaf index}
\usage{
nonNormalizedBanzhafIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
The return value is a vector which contains the non-normalized Banzhaf index for each player.
}
\description{
non-normalized Banzhaf index for a specified simple game, see 
formula (7.5) on p. 119 of the book by Chakravarty, Mitra and Sarkar
}
\examples{
library(CoopGame)
nonNormalizedBanzhafIndex(dictatorGameVector(n=3, dictator=1))

\donttest{
library(CoopGame)
v<-weightedVotingGameVector(n=4,w=c(8,6,4,2),q=c(12))
nonNormalizedBanzhafIndex(v)
#[1] 0.625 0.375 0.375 0.125

library(CoopGame)
v<- apexGameVector(n = 4,apexPlayer=3)
nonNormalizedBanzhafIndex(v)
#[1] 0.25 0.25 0.75 0.25

library(CoopGame)
#N=c(1,2,3), w=(50,49,1), q=51   
v=weightedVotingGameVector(n=3, w=c(50,49,1),q=51)
nonNormalizedBanzhafIndex(v)
#[1] 0.75 0.25 0.25

library(CoopGame) 
v<-weightedVotingGameVector(n=3,w=c(50,30,20),q=c(67))
nonNormalizedBanzhafIndex(v)
#[1] 0.75 0.25 0.25
}

}
\references{
Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 118--119

Bertini C. and Stach I. (2011) "Banzhaf voting power measure", Encyclopedia of Power, SAGE Publications, pp. 54--55
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
