% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidAllocation}
\alias{stopOnInvalidAllocation}
\title{Parameter Function stopOnInvalidAllocation}
\usage{
stopOnInvalidAllocation(paramCheckResult, x, n = NULL, v = NULL)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{x}{numeric vector containing allocations for each player}

\item{n}{represents the number of players}

\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\description{
stopOnInvalidAllocation checks if allocation
 is specified correctly.
 Validation result gets stored to object paramCheckResult 
 in case an error occured and causes calculation to stop.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1100 \tab Allocation 'x' is NULL \cr
1101 \tab Allocation 'x' is not of type numeric. \cr
1102 \tab Allocation 'x' has wrong number of elements as compared to number of players. \cr
1103 \tab Allocation is inconsistent with game vector. }
}

\examples{
library(CoopGame)
paramCheckResult=getEmptyParamCheckResult()
validAllocation=c(1,2,3)
stopOnInvalidAllocation(paramCheckResult,x=validAllocation,n=3)

}
\seealso{
Other ParameterChecks_CoopGame: \code{\link{getEmptyParamCheckResult}},
  \code{\link{stopOnInconsistentEstateAndClaimsVector}},
  \code{\link{stopOnInvalidBoolean}},
  \code{\link{stopOnInvalidClaimsVector}},
  \code{\link{stopOnInvalidCoalitionS}},
  \code{\link{stopOnInvalidDictator}},
  \code{\link{stopOnInvalidEstate}},
  \code{\link{stopOnInvalidGameVector}},
  \code{\link{stopOnInvalidGrandCoalitionN}},
  \code{\link{stopOnInvalidIndex}},
  \code{\link{stopOnInvalidLeftRightGloveGame}},
  \code{\link{stopOnInvalidNChooseB}},
  \code{\link{stopOnInvalidNumberOfPlayers}},
  \code{\link{stopOnInvalidNumber}},
  \code{\link{stopOnInvalidQuota}},
  \code{\link{stopOnInvalidVetoPlayer}},
  \code{\link{stopOnInvalidWeightVector}},
  \code{\link{stopOnParamCheckError}}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
\concept{ParameterChecks_CoopGame}
