% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CountChemicalElements.R
\name{CountChemicalElements}
\alias{CountChemicalElements}
\title{CountChemicalElements.}
\usage{
CountChemicalElements(x = NULL, ele = NULL)
}
\arguments{
\item{x}{Chemical formula.}

\item{ele}{Character vector of elements to count particularly or counting all contained in string if NULL.}
}
\value{
A named numeric with counts for all contained or specified elements.
}
\description{
\code{CountChemicalElements} will split a character (chemical formula)
 into its elements and count their occurrence.
}
\details{
No testing for any chemical alphabet is performed. Elements may occur
 several times and will be summed up in this case without a warning.
 Information within brackets, i.e. [13]C will be removed prior to counting
 together with other symbols not contained in the R set 'alnum'.
 The result is filtered and ordered according to parameter 'ele' if provided.
}
\examples{
# count every element
CountChemicalElements("C3H7Cl")

# remove additional symbols and sum up redundant elements (here 'C')
CountChemicalElements("[13]CC2H8Cl+")

# count specific elements and return in specified order
CountChemicalElements("[13]CC2H8Cl+", ele=c("Cl","O","H"))

# apply on a vector of formulas using sapply
sapply(c("C3H7Cl", "[13]CC2H8Cl+"), CorMID::CountChemicalElements, ele=c("Cl","O","H"))
}
