% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchNearestNeighbor.R
\name{matchNearestNeighbor}
\alias{matchNearestNeighbor}
\title{Match Nearest Neighbor Between Two Datasets}
\usage{
matchNearestNeighbor(
  dataset = cs.in.dataset(),
  preds = cs.in.predictors(),
  auxs = cs.in.auxiliaries(),
  robject = cs.in.Robject(),
  return.results = FALSE
)
}
\arguments{
\item{dataset}{[\code{\link{data.frame}}]\cr
Dataset with named columns. The names correspond to predictors and responses.}

\item{preds}{[\code{character}]\cr
Character vector of predictor variables.}

\item{auxs}{[\code{character}]\cr
Character vector of auxiliary variables.}

\item{robject}{[\code{list}]\cr
Named list of one
\code{\link{redirectDataset}}
object(s) set via Cornerstone menu "Input R Objects".}

\item{return.results}{[\code{logical(1)}]\cr
If \code{FALSE} the function returns \code{TRUE} invisibly.
If \code{TRUE}, it returns a \code{\link{list}} of results.
Default is \code{FALSE}.}
}
\value{
Logical [\code{TRUE}] invisibly and outputs to Cornerstone or, 
  if \code{return.results = TRUE}, \code{\link{list}} of 
  resulting \code{\link{data.frame}} objects:
  \item{nearest.neighbor}{
    Matched nearest neighbor which consists of predictor and available response, group, and 
    auxiliary variables. The calculated distance is attached to this dataset.
  }
  \item{runtimes}{
    Run times for every input R object.
  }
}
\description{
Match the nearest neighbor from a redirected Cornerstone \code{Robject} dataset 
  (\code{\link{redirectDataset}}) to corresponding selected predictor variables.
  Predictor variables from both datasets are supposed to be numeric to apply the Euclidean
  distance calculated by \code{\link[SpatialTools]{dist2}}.
  The function returns a dataset with the nearest neighbor to every observation, matched by 
  the predictor variables.
  Available response, group, and auxiliary variables from the redirected datasets are passed
  through, as well as, selected auxiliary variables.
  The calculated distance is attached.
}
