% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExchMultinomial.R
\name{jointprobs}
\alias{jointprobs}
\title{Estimate joint event probabilities for multinomial data}
\usage{
jointprobs(cmdata, type = c("averaged", "cluster", "mc"))
}
\arguments{
\item{cmdata}{a \code{CMData} object}

\item{type}{character string describing the desired type of estimate:
\itemize{
 \item{"averaged"}{ - averaged over the observed cluster-size distribution within each treatment}
 \item{"cluster"}{ - separately for each cluster size within each treatment}
 \item{"mc"}{ - assuming marginal compatibility, ie that \eqn{\tau} does not depend on the cluster-size}
}}
}
\value{
a list with an array of estimates for each treatment. For a multinomial distribution with
\eqn{K+1} categories the arrays will have either \eqn{K+1} or {K} dimensions, depending on whether 
cluster-size specific estimates (\code{type="cluster"}) or pooled estimates 
(\code{type="averaged"} or \code{type="mc"}) are requested. For the cluster-size specific estimates 
the first dimension is the cluster-size. Each additional dimension is a possible outcome.
}
\description{
An exchangeable multinomial distribution with \eqn{K+1} categories \eqn{O_1,\ldots,O_{K+1}}, can be
parameterized by the joint probabilities of events
\deqn{\tau_{r_1,\ldots,r_{K}|n} = P\big[X_1=\cdots=X_{r_1}=O_1,\ldots, X_{\sum_{i=1}^{K-1}r_i+1} =\cdots=X_{\sum_{i=1}^{K}r_i}=O_K\big] }{tau_{r_1,..,r_K|n} = P[X_1=...=X_{r_1}=O_1,..., X_{sum_{i=1}^{K-1}r_i+1} =...=X_{sum_{i=1}^{K}r_i}=O_K]}
where \eqn{r_i \geq 0} and \eqn{r_1+\cdots +r_K\leq n}.
The \code{jointprobs} function estimates these probabilities under various settings. 
Note that when some of the \eqn{r_i}'s equal zero, then no restriction on the number of outcomes of the 
corresponding type are imposed, so the resulting probabilities are marginal.
}
\examples{
data(dehp)
# averaged over cluster-sizes
tau.ave <- jointprobs(dehp, type="ave")
# averaged P(X1=X2=O1, X3=O2) in the 1500 dose group
tau.ave[["1500"]]["2","1"]  # there are two type-1, and one type-2 outcome

#plot P(X1=O1) - the marginal probability of a type-1 event over cluster-sizes
tau <- jointprobs(dehp, type="cluster")
ests <- as.data.frame(lapply(tau, function(x)x[,"1","0"]))
matplot(ests, type="b")
}
\seealso{
\code{\link{mc.est}} for estimating the distribution under marginal compatibility,
\code{\link{uniprobs}} and \code{\link{multi.corr}} for extracting the univariate marginal event
probabilities, and the within-multinomial correlations from the joint probabilities.
}
