% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reprod.R
\name{SO.trend.test}
\alias{SO.trend.test}
\title{Likelihood ratio test of stochastic ordering}
\usage{
SO.trend.test(cbdata, R = 100, control = soControl())
}
\arguments{
\item{cbdata}{a \code{\link{CBData}} object.}

\item{R}{an integer -- the number of random permutations for estimating the
null distribution.}

\item{control}{an optional list of control settings, usually a call to
\code{\link{soControl}}.  See there for the names of the settable control
values and their effect.}
}
\value{
A list with the following components

\item{LRT}{the value of the likelihood ratio test statistic. It has two
attributes: \code{ll0} and \code{ll1} - the values of the log-likelihood
under \eqn{H_0}{H0} and \eqn{H_a}{Ha} respectively.}

\item{p.val}{the estimated one-sided p-value.}

\item{boot.res}{an object of class "boot" with the detailed results of
the permutations.  See \code{\link[boot]{boot}} for details.}
}
\description{
Performs a likelihood ratio test of stochastic ordering versus equality using
permutations to estimate the null-distribution and the p-value.  If only the
value of the test statistic is needed, use \code{\link{SO.LRT}} instead.
}
\details{
The test is valid only under the assumption that the cluster-size
distribution does not depend on group. During the estimation of the
null-distribution the group assignments of the clusters are permuted keeping
the group sizes constant; the within-group distribution of the cluster-sizes
will vary randomly during the permutation test.

The default value of \code{R} is probably too low for the final data
analysis, and should be increased.
}
\examples{

data(shelltox)
set.seed(45742)
sh.test <- SO.trend.test(shelltox, R=5, control=soControl(eps=0.1, max.directions=25)) 
sh.test

#a plot of the resampled LRT values
#would look better with a reasonable value of R
null.vals <- sh.test$boot.res$t[,1]
hist(null.vals, breaks=10,  freq=FALSE, xlab="Test statistic", ylab="Density", 
     main="Simulated null-distribution", xlim=range(c(0,20,null.vals)))
points(sh.test$LRT, 0, pch="*",col="red", cex=3)

}
\references{
Szabo A, George EO. (2009) On the Use of Stochastic Ordering to
Test for Trend with Clustered Binary Data.
}
\seealso{
\code{\link{SO.LRT}} for calculating only the test statistic,
\code{\link{soControl}}
}
\author{
Aniko Szabo, aszabo@mcw.edu
}
\keyword{htest}
\keyword{nonparametric}
