% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExchMultinomial.R, R/Reprod.R,
%   R/aaa-generics1.R
\name{mc.test.chisq.CMData}
\alias{mc.test.chisq.CMData}
\alias{mc.test.chisq.CBData}
\alias{mc.test.chisq}
\title{Test the assumption of marginal compatibility}
\usage{
\method{mc.test.chisq}{CMData}(object, ...)

\method{mc.test.chisq}{CBData}(object, ...)

mc.test.chisq(object, ...)
}
\arguments{
\item{object}{a \code{\link{CBData}} or \code{\link{CMData}} object}

\item{\dots}{other potential arguments; not currently used}
}
\value{
A list with the following components:

\item{overall.chi}{the test statistic; sum of the statistics for each
group}

\item{overall.p}{p-value of the test}

\item{individual}{a list of the results of the test applied to each
group separately: \itemize{ \item chi.sq the test statistic for the group
\item p p-value for the group}}
}
\description{
\code{mc.test.chisq} tests whether the assumption of marginal compatibility is
violated in the data.
}
\details{
The assumption of marginal compatibility (AKA reproducibility or interpretability) implies that
the marginal probability of response does not depend on clustersize.
Stefanescu and Turnbull (2003), and Pang and Kuk (2007) developed a
Cochran-Armitage type test for trend in the marginal probability of success
as a function of the clustersize. \code{mc.test.chisq} implements a
generalization of that test extending it to multiple treatment groups.
}
\examples{

data(dehp)
mc.test.chisq(dehp)


data(shelltox)
mc.test.chisq(shelltox)

}
\references{
Stefanescu, C. & Turnbull, B. W. (2003) Likelihood inference for
exchangeable binary data with varying cluster sizes. \emph{Biometrics}, 59,
18-24

Pang, Z. & Kuk, A. (2007) Test of marginal compatibility and smoothing
methods for exchangeable binary data with unequal cluster sizes.
\emph{Biometrics}, 63, 218-227
}
\seealso{
\code{\link{mc.est}} for estimating the distribution under marginal
compatibility.
}
\author{
Aniko Szabo
}
\keyword{htest}
