% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{cross.screen}
\alias{cross.screen}
\alias{cross.screen.fg}
\title{Cross-screening}
\usage{
cross.screen(d1, d2, gamma = 1, mm = c(2, 2, 2), alpha.screen = 0.05,
  gamma.screen = 0, two.sided = TRUE)

cross.screen.fg(d1, d2, gamma = 1, screen.method = c("threshold",
  "least_sensitive"), alpha.screen = 0.05, alpha.least.sensitive = 2,
  gamma.screen = gamma, mm = c(2, 2, 2), two.sided = TRUE)
}
\arguments{
\item{d1}{screen/test sample (treatment-minus-control differences), can be a matrix (rows are observations, columns are hypotheses)}

\item{d2}{test/screen sample, can be a matrix}

\item{gamma}{sensitivity parameter (maximum odds different from a randomized experiment)}

\item{mm}{a vector of matrix. If matrix, adaptively choose statistic. NULL means Wilcoxon's signed rank statistic.}

\item{alpha.screen}{significance level used in screening.}

\item{gamma.screen}{screening threshold, default is 0, meaning no screening is used.}

\item{two.sided}{if TRUE, automatically select the sign to test; if FALSE, test the one-sided alternative that the center of \code{d} is positive.}

\item{screen.method}{either keep all hypotheses significant at \code{gamma.screen} (option "threshold") or keep the least sensitive hypotheses (option "least_sensitive").}

\item{alpha.least.sensitive}{the number of least sensitive hypotheses to keep}
}
\value{
\code{cross.screen} returns a list
\describe{
\item{s1.kappa}{kappa values used to screen the hypotheses calculated using the first sample}
\item{s1.stat}{test statistics chosen using the first sample, if \code{mm} has more than 1 column}
\item{s1.side}{signs of alternative hypotheses chosen using the first sample}
\item{s1.order}{order of the hypotheses by \code{s1.kappa} if \code{s1.kappa} is above the threshold \code{gamma.screen}}
\item{p1}{p-values computed using the first sample at sensitivity \code{gamma}}
\item{s2.kappa}{kappa values used to screen the hypotheses calculated using the second sample}
\item{s2.stat}{test statistics chosen using the second sample, if \code{mm} has more than 1 column}
\item{s2.side}{signs of alternative hypotheses chosen using the second sample}
\item{s2.order}{order of the hypotheses by \code{s1.kappa} if \code{s1.kappa} is above the threshold \code{gamma.screen}}
\item{p2}{p-values computed using the second sample at sensitivity \code{gamma}}
\item{p}{Bonferroni adjusted p-values at sensitivity \code{gamma} computed using \code{p1} and \code{p2} (they can be directly used to control FWER)}
}

\code{cross.screen.fg} returns a list
\describe{
\item{s1.p}{p-values used to screen the hypotheses calculated using the first sample}
\item{s1.stat}{test statistics chosen using the first sample, if \code{mm} has more than 1 column}
\item{s1.side}{signs of alternative hypotheses chosen using the first sample}
\item{s1.order}{order of the hypotheses by \code{s1.p} if \code{s1.p} is below the threshold \code{alpha.screen}}
\item{p1}{p-values computed using the first sample at sensitivity \code{gamma}}
\item{s2.p}{p-values used to screen the hypotheses calculated using the second sample}
\item{s2.stat}{test statistics chosen using the second sample, if \code{mm} has more than 1 column}
\item{s2.side}{signs of alternative hypotheses chosen using the second sample}
\item{s2.order}{order of the hypotheses by \code{s2.p} if \code{s2.p} is above the threshold \code{alpha.screen}}
\item{p2}{p-values computed using the second sample at sensitivity \code{gamma}}
\item{p}{Bonferroni adjusted p-values at sensitivity \code{gamma} computed using \code{p1} and \code{p2} (they can be directly used to control FWER)}
}
}
\description{
Main functions that implements the cross-screening method in observational studies. \code{cross.screen} sorts the hypotheses by their sensitivity values and \code{cross.screen.fg} sorts by p-values at a fixed sensitivity \eqn{\Gamma}.
}
\section{Functions}{
\itemize{
\item \code{cross.screen.fg}: Cross-screening with fixed \eqn{\Gamma}
}}
\examples{

n <- 100
p <- 20
d <- matrix(rnorm(n * p), n, p)
d[, 1] <- d[, 1] + 2
d1 <- d[1:(n/2), ]
d2 <- d[(n/2+1):n, ]
cross.screen(d1, d2,
             gamma = 9,
             gamma.screen = 1.25)$p

## One can run the hidden function CrossScreening:::table5(no.sims = 1)
## to generate Table 5 in the paper.


## The following code generates Table 1 in the paper.

data(nhanes.fish)
data(nhanes.fish.match)

data <- nhanes.fish
match <- nhanes.fish.match

outcomes <- grep("^o\\\\.", names(data))
log2diff <- function(y1, y2) {
    if (min(c(y1, y2)) == 0) {
        y1 <- y1 + 1
        y2 <- y2 + 1
    }
    log2(y1) - log2(y2)
}
d <- sapply(outcomes, function(j) log2diff(data[match$treated, j], data[match$control, j]))
set.seed(11)
split <- sample(1:nrow(d), nrow(d) / 2, replace = FALSE)
d1 <- d[split, ]
d2 <- d[-split, ]

mm <- matrix(c(2, 2, 2, 8, 5, 8), ncol = 2)
data.frame(outcome = names(data)[outcomes],
           p.value =
               cross.screen.fg(d1, d2,
                               gamma = 9,
                               screen.method = "least_sensitive",
                               mm = mm)$p)


}
\author{
Qingyuan Zhao
}
\references{
Qingyuan Zhao, Dylan S. Small, Paul R. Rosenbaum. Cross-screening in observational studies that test many hypotheses. arXiv preprint arXiv:1703.02078
}

