% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureAccuracy.R
\name{MeasureAccuracy}
\alias{MeasureAccuracy}
\title{Measures of Accuracy}
\usage{
MeasureAccuracy(
  measure = c("SSE", "MSE", "MAE", "MAPE", "All"),
  qxt_re,
  qxt_aju,
  wxt
)
}
\arguments{
\item{measure}{choose the non-penalized measure of accuracy that you want to use; c("\code{SSE}", "\code{MSE}", "\code{MAE}", "\code{MAPE}", "\code{All}"). Check the function. In case you do not provide any value, the function will apply the "\code{SSE}" as measure of forecasting accuracy.}

\item{qxt_re}{real mortality rates used to check the goodness of fit measure.}

\item{qxt_aju}{adjusted mortality rates using a specific mode.}

\item{wxt}{weights of the mortality rates or data provided.}
}
\value{
An object with class \code{"MoA"} including the value of the measure of accuracy for the data provided.
}
\description{
R function to estimate different measures of accuracy.
\enumerate{
\item the sum of squared errors (SSE) for the mortality rates:
\deqn{\sum_{x}^{} \sum_{t} \left( qxt1 - qxt2 \right)^{2}}
where qxt1 is the real mortality rates \code{qxt_re}, and qxt2 is the adjusted mortality rates \code{qxt_aju}.
\item The mean squared errors (MSE) for the mortality rates:
\deqn{\frac{1}{n}\sum_{x} \sum_{t} \left( qxt1 - qxt2 \right)^2 = \frac{1}{n} SSE}
where qxt1 is the real mortality rates \code{qxt_re}, and qxt2 is the adjusted mortality rates \code{qxt_aju}.
\item The mean absolute errors (MAE) for the mortality rates:
\deqn{\frac{1}{n}\sum_{x} \sum_{t} \left| qx1 - qxt2 \right|}.
where qxt1 is the real mortality rates \code{qxt_re}, and qxt2 is the adjusted mortality rates \code{qxt_aju}.
\item The mean absolute percentage error (MAPE) for the mortality rates:
\deqn{\frac{1}{n}\sum_{x} \sum_{t}\left| \frac{\left(qxt1 - qxt2\right) }{qxt2} \right|}
where qxt1 is the real mortality rates \code{qxt_re}, and qxt2 is the adjusted mortality rates \code{qxt_aju}.
You only have to provide the real value, the fitted or forecasted value for your mortality rates and the measure of accuracy chosen.
However, the function is constructed to provide the real value and the fitted or forecasted value of your independent variable.
These variables must have the same dimensions to be compared.
}
}
\examples{
#The example takes more than 5 seconds because it includes
#several fitting and forecasting process and hence all
#the process is included in donttest
\donttest{
#To show how the function works, we need to provide fitted or forecasted data and the real data.
#In this case, we employ the following data of the library:
SpainRegions

library(gnm)
library(forecast)
ages <- c(0, 1, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90)
#In this case, we fit for males providing the lxt
multiplicative_Spainmales <- fitLCmulti(model = "multiplicative",
                              qxt = SpainRegions$qx_male,
                              periods = c(1991:2020),
                              ages = c(ages),
                              nPop = 18,
                              lxt = SpainRegions$lx_male)

multiplicative_Spainmales
plot(multiplicative_Spainmales)

#Once, we have the fitted data, we will obtain different measures of accuracy
#for the first population.
#We need to obtain wxt (weight of the mortality rates or data provided) using a
library(StMoMo)
wxt_1pob <- genWeightMat(ages = ages, years = c(1991:2020), clip = 0)

##########################
#SSE#
##########################
SSE_multSpmales <- MeasureAccuracy(measure = "SSE",
                       qxt_re = multiplicative_Spainmales$qxt.real$pob1,
                       qxt_aju = multiplicative_Spainmales$qxt.fitted$pob1,
                       wxt = wxt_1pob)
SSE_multSpmales
##########################
#MSE#
##########################
MSE_multSpmales <- MeasureAccuracy(measure = "MSE",
                       qxt_re = multiplicative_Spainmales$qxt.real$pob1,
                       qxt_aju = multiplicative_Spainmales$qxt.fitted$pob1,
                       wxt = wxt_1pob)
MSE_multSpmales
##########################
#MAE#
##########################
MAE_multSpmales <- MeasureAccuracy(measure = "MSE",
                       qxt_re = multiplicative_Spainmales$qxt.real$pob1,
                       qxt_aju = multiplicative_Spainmales$qxt.fitted$pob1,
                       wxt = wxt_1pob)
MAE_multSpmales
##########################
#MAPE#
##########################
MAPE_multSpmales <- MeasureAccuracy(measure = "MSE",
                        qxt_re = multiplicative_Spainmales$qxt.real$pob1,
                        qxt_aju = multiplicative_Spainmales$qxt.fitted$pob1,
                        wxt = wxt_1pob)
MAPE_multSpmales

}

}
\references{
Atance, D., Debón, A., & Navarro, E. (2020).
A comparison of forecasting mortality models using resampling methods.
Mathematics, 8(9), 1550.
}
\seealso{
\code{\link{fitLCmulti}}, \code{\link{forecast.fitLCmulti}},
\code{\link{multipopulation_cv}}, \code{\link{multipopulation_loocv}}.
}
