% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citrus.R
\docType{methods}
\name{citrus}
\alias{citrus}
\alias{citrus.copy_settings}
\alias{citrus.copy_settings,UserSession,CITRUS-method}
\alias{citrus.delete}
\alias{citrus.delete,UserSession,CITRUS-method}
\alias{citrus.download}
\alias{citrus.download,UserSession,CITRUS-method}
\alias{citrus.list}
\alias{citrus.list,UserSession-method}
\alias{citrus.new}
\alias{citrus.new,UserSession-method}
\alias{citrus.rename}
\alias{citrus.rename,UserSession,CITRUS-method}
\alias{citrus.run}
\alias{citrus.run,UserSession,CITRUS-method}
\alias{citrus.show}
\alias{citrus.show,UserSession-method}
\alias{citrus.status}
\alias{citrus.status,UserSession,CITRUS-method}
\alias{citrus.update}
\alias{citrus.update,UserSession,CITRUS-method}
\title{CITRUS Endpoints}
\usage{
\S4method{citrus.copy_settings}{UserSession,CITRUS}(UserSession, citrus,
  output = "default", timeout = UserSession@short_timeout)

\S4method{citrus.delete}{UserSession,CITRUS}(UserSession, citrus,
  timeout = UserSession@short_timeout)

\S4method{citrus.download}{UserSession,CITRUS}(UserSession, citrus,
  directory = getwd(), timeout = UserSession@long_timeout)

\S4method{citrus.list}{UserSession}(UserSession, experiment_id,
  output = "default", timeout = UserSession@short_timeout)

\S4method{citrus.new}{UserSession}(UserSession, experiment_id, citrus_name,
  timeout = UserSession@long_timeout)

\S4method{citrus.rename}{UserSession,CITRUS}(UserSession, citrus, citrus_name,
  timeout = UserSession@short_timeout)

\S4method{citrus.run}{UserSession,CITRUS}(UserSession, citrus,
  output = "default", timeout = UserSession@long_timeout)

\S4method{citrus.show}{UserSession}(UserSession, experiment_id, citrus_id,
  timeout = UserSession@short_timeout)

\S4method{citrus.status}{UserSession,CITRUS}(UserSession, citrus,
  output = "default", timeout = UserSession@long_timeout)

\S4method{citrus.update}{UserSession,CITRUS}(UserSession, citrus,
  timeout = UserSession@long_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{citrus}{Cytobank CITRUS object}

\item{output}{character representing the output format  \strong{[optional]}\cr
\emph{- citrus.list, citrus.run, citrus.status : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds  \strong{[optional]}}

\item{directory}{character representing a specific directory to which the file will be downloaded (optional ending directory slash), if left empty, the default will be the current working directory \strong{[optional]}}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{citrus_name}{character representing a new CITRUS name}

\item{citrus_id}{integer representing a CITRUS ID}
}
\description{
Interact with CITRUS advanced analyses using these endpoints.
}
\details{
\code{citrus.copy_settings} Copy CITRUS advanced analysis settings from an experiment and returns a CITRUS object.

\code{citrus.delete} Delete a CITRUS advanced analysis from an experiment.

\code{citrus.download} Download a CITRUS analysis from an experiment.

\code{citrus.list} List all CITRUS advanced analyses from an experiment. Outputs a dataframe [default] or list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{citrus.new} Create a new CITRUS advanced analysis from an experiment and returns a CITRUS object.

\code{citrus.rename} Rename a CITRUS advanced analysis from an experiment and returns a CITRUS object.

\code{citrus.run} Run a CITRUS advanced analysis from an experiment.

\code{citrus.show} Show CITRUS advanced analysis details from an experiment and returns a CITRUS object.

\code{citrus.status} Run a CITRUS advanced analysis from an experiment.

\code{citrus.update} Update a CITRUS advanced analysis from an experiment and returns the new CITRUS object.
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\donttest{citrus.copy_settings(cyto_session, citrus=cyto_citrus)
}
\donttest{citrus.delete(cyto_session, citrus=cyto_citrus)
}
\donttest{# Download a CITRUS analysis to the current working directory
citrus.download(cyto_session, citrus)

# Download a CITRUS analysis to a new directory
citrus.download(cyto_session, citrus, directory="/my/new/download/directory/")
}
\donttest{# Dataframe of all CITRUS advanced analyses with all fields present
citrus.list(cyto_session, 22)

# Raw list of all CITRUS advanced analyses with all fields present
citrus.list(cyto_session, 22, output="raw")
}
\donttest{citrus.new(cyto_session, 22, citrus_name="My new CITRUS analysis")
}
\donttest{citrus.rename(cyto_session, citrus=cyto_citrus, citrus_name="My updated CITRUS name")
}
\donttest{citrus.run(cyto_session, citrus=cyto_citrus)
}
\donttest{citrus.show(cyto_session, 22, citrus_id=2)
}
\donttest{citrus.status(cyto_session, citrus=cyto_citrus)
}
\donttest{citrus.update(cyto_session, citrus=cyto_citrus)
}
}

