% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/d3m_main.R
\name{d3m}
\alias{d3m}
\title{Two Sample Test with Distribution-Valued Data}
\usage{
d3m(cases, control, rm.mean = FALSE, rm.var = FALSE, paranum = 101,
  q = 2, bsn = 5000, seed = 100)
}
\arguments{
\item{cases}{name of case group data (matrix)}

\item{control}{names of control group data (matrix)}

\item{rm.mean}{standarize each rows of cases and control to mean=0.}

\item{rm.var}{standarize each rows of cases and control to var=1.}

\item{paranum}{the number of quatile discretization + 1. Default is discretized by 1 \%.}

\item{q}{power of Wasserstein metric. Default is q = 2.}

\item{bsn}{the number of resampling. Default is bsn = 5000.}

\item{seed}{seed for random number generator.}
}
\value{
pval p-value.

test.stat test statistic.

cases case group data used in the statistical test.

control control group data used in the statistical test.
}
\description{
Two Sample Test with Distribution-Valued Data
}
\details{
this function is designed for two sample test based on Wasserstein metric. The function computes the the p-values based Wasserstein metric and resampling method. If rm.mean=F and rm.var=F, then statistical test is performed only based on more than 3rd order moments.
}
\examples{
nrep <-12
cases <- Map(rbeta,rep(30,nrep),rep(1,nrep),rep(5,nrep)); cases <- do.call("rbind",cases)
control <- Map(rbeta,rep(30,nrep),rep(1,nrep),rep(5,nrep)); control <- do.call("rbind",control)
d3m(cases,control,paranum = 101, q = 2, bsn = 1000,seed = 100)
}
\author{
Yusuke Matsui & Teppei Shimamura
}

