% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_island_species.R
\name{extract_island_species}
\alias{extract_island_species}
\title{Extracts the colonisation, diversification, and endemicty data from
phylogenetic and endemicity data and stores it in an `Island_tbl` object}
\usage{
extract_island_species(
  phylod,
  extraction_method,
  island_tbl = NULL,
  include_not_present = FALSE,
  unique_clade_name = TRUE
)
}
\arguments{
\item{phylod}{A `phylo4d` object from the package `phylobase` containing
phylogenetic and endemicity data for each species.}

\item{extraction_method}{A character string specifying whether the
colonisation time extracted is the minimum time (`min`) (before the present),
or the most probable time under ancestral state reconstruction (`asr`).}

\item{island_tbl}{An instance of the `Island_tbl` class.}

\item{include_not_present}{A boolean determining whether species not present
on the island should be included in island colonist when embedded within an
island clade. Default is FALSE.}

\item{unique_clade_name}{Boolean determining whether a unique species
identifier is used as the clade name in the Island_tbl object or a genus
name which may not be unique if that genus has several independent island
colonisations}
}
\value{
An object of `Island_tbl` class
}
\description{
Extracts the colonisation, diversification, and endemicty data from
phylogenetic and endemicity data and stores it in an `Island_tbl` object
}
\examples{
set.seed(
  1,
  kind = "Mersenne-Twister",
  normal.kind = "Inversion",
  sample.kind = "Rejection"
)
phylo <- ape::rcoal(10)
phylo$tip.label <- c("bird_a", "bird_b", "bird_c", "bird_d", "bird_e",
                     "bird_f", "bird_g", "bird_h", "bird_i", "bird_j")
phylo <- phylobase::phylo4(phylo)
endemicity_status <- sample(
  c("not_present", "endemic", "nonendemic"),
  size = length(phylobase::tipLabels(phylo)),
  replace = TRUE,
  prob = c(0.6, 0.2, 0.2)
)
phylod <- phylobase::phylo4d(phylo, as.data.frame(endemicity_status))
extract_island_species(phylod, extraction_method = "min")
}
