% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overall_comparison.R
\name{overall_comparison}
\alias{overall_comparison}
\title{Compare champion with challengers globally}
\usage{
overall_comparison(champion, challengers, type)
}
\arguments{
\item{champion}{- explainer of champion model.}

\item{challengers}{- explainer of challenger model or list of explainers.}

\item{type}{- type of the task. Either classification or regression}
}
\value{
An object of the class overall_comparison

 It is a named list containing following fields:
\itemize{
\item \code{radar} list of \code{\link[auditor]{model_performance}} objects and other parameters that will be passed to generic \code{plot} function
\item \code{accordance} data.frame object of champion responses and challenger's corresponding to them. Used to plot accordance.
\item \code{models_info} data.frame containig inforamtion about models used in analysys.
}
}
\description{
The function creates objects that present global model perfromance using various measures. Those date can be easily
ploted with \code{plot} function. It uses \code{auditor} package to create \code{\link[auditor]{model_performance}} of all passed
explainers. Keep in mind that type of task has to be specified.
}
\examples{
\donttest{
library("DALEXtra")
library("mlr")
task <- mlr::makeRegrTask(
  id = "R",
  data = apartments,
  target = "m2.price"
)
learner_lm <- mlr::makeLearner(
  "regr.lm"
)
model_lm <- mlr::train(learner_lm, task)
explainer_lm <- explain_mlr(model_lm, apartmentsTest, apartmentsTest$m2.price, label = "LM")

learner_rf <- mlr::makeLearner(
  "regr.randomForest"
)
model_rf <- mlr::train(learner_rf, task)
explainer_rf <- explain_mlr(model_rf, apartmentsTest, apartmentsTest$m2.price, label = "RF")

learner_gbm <- mlr::makeLearner(
  "regr.gbm"
)
model_gbm <- mlr::train(learner_gbm, task)
explainer_gbm <- explain_mlr(model_gbm, apartmentsTest, apartmentsTest$m2.price, label = "gbm")

data <- overall_comparison(explainer_lm, list(explainer_gbm, explainer_rf), type = "regression")
plot(data)
}
}
