% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{plot.balsos}
\alias{plot.balsos}
\title{Plot Results from BALSOS}
\usage{
\method{plot}{balsos}(x, ..., freq = TRUE, offset = 0.1, plot = TRUE)
}
\arguments{
\item{x}{Object of class \code{balsos}.}

\item{...}{Other arguments to be passed down, currently not implement and
may conflict with the lattice figure.  To change the figure the best advice
would be to save the plot as an oject and use the \code{update} function to
change its features.}

\item{freq}{Logical indicating whether you want the frequentist result
plotted alongside the Bayesian result.}

\item{offset}{If \code{freq=T}, the Bayesian points will be plotted at
\code{x-offset} and the frequentist points will be plotted at
\code{x+offset}.}

\item{plot}{Logical indicating whether the plot should be returned or just the data.}
}
\value{
A lattice graph produce by a call to \code{xyplot}.
}
\description{
Plots the optimally scaled points with posterior 95\% credible intervals.
}
\author{
Dave Armstrong
}
