% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEET_enrichment_plot.R
\name{DEET_enrichment_plot}
\alias{DEET_enrichment_plot}
\title{DEET_enrichment_plot}
\usage{
DEET_enrichment_plot(
  enrich_list,
  outname,
  width = 8,
  text_angle = 0,
  horizontal = FALSE,
  topn = 5,
  ol_size = 1,
  exclude_domain = "",
  cluster_order = NULL,
  dot = FALSE,
  colors = "Set2",
  split_domain = FALSE
)
}
\arguments{
\item{enrich_list}{A list of enrichments from DEET, with each element
post-processed with the barplot enrichment function.}

\item{outname}{A character giving the title of the barplot or dotplot.}

\item{width}{The number of inches in the barplot or dotplot.}

\item{text_angle}{The angle of the enriched studies.}

\item{horizontal}{Whether the output barplot is vertical or horizontal}

\item{topn}{the top number of studies (by p-value) to be plotted.}

\item{ol_size}{the minimum number of overlapping genes (or paths) in an enriched study.}

\item{exclude_domain}{Exclude studies enriched based on DEGs, Paths, or TF if
the user happened to aggregate the results into a single DF, generally unused.}

\item{cluster_order}{Factor to group studies based on the researchers custom annotation.}

\item{dot}{logical (T/F) of whether to produce a dotplot or a barplot}

\item{colors}{Type of color pallete to input into 'scale_fill_brewer' of ggplot.}

\item{split_domain}{logical (T/F) of whether to plot the "topn" studies for
each "domain" (default is source) or to plot the topn pathwys regardless of domain.
default is set to FALSE, meaning it plots the topn pathways regardless of domain.}
}
\value{
A ggplot2 object (barplot or dotplot) of enrichment identified within DEET.
}
\description{
Generate barplots or dotplots from the output of DEET
}
\examples{

data("example_DEET_enrich_input")
data("DEET_example_data")
DEET_out <- DEET_enrich(example_DEET_enrich_input, DEET_dataset = DEET_example_data)

# converting output to format compatible with DEET_enrichment plot
DE_example <- DEET_out$AP_DEET_DE_output$results
DE_example$term.name <- DEET_out$AP_DEET_DE_output$metadata$DEET.Name
DE_example$domain <- "DE"
DE_example$overlap.size <- lengths(DE_example$overlap)
DE_example$p.value <- DE_example$adjusted.p.val

DE_example_plot <- DEET_enrichment_plot(list(DE_example = DE_example), "DE_example")


}
\author{
Dustin Sokolowski, Hauyun Hou PhD
}
