% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DE_expr_plots.R
\name{de_diverge_plot}
\alias{de_diverge_plot}
\title{Visualize fold-change divergence for differentially expressed genes.}
\usage{
de_diverge_plot(res_list, filename = "de_divergence_plot.pdf",
  theme = 1, customLabels = FALSE, returnData = FALSE)
}
\arguments{
\item{res_list}{A list of DESeq result sets. Results can be calculated individually using DESeq's results() function.
Lists of results can be created by creating a list(result1, result2 ... result_N).}

\item{filename}{Filename for output plot.  Valid extensions are ".pdf" and ".png".
File generation can be turned off using set_output_mode("screen"). Output will be written to the /DE/divergence/ directory.}

\item{theme}{Theme for the layout and color scheme for the plot.  Valid selections are integers between 1-6.}

\item{customLabels}{If customLabels is set to TRUE, the user will be prompted to provide a custom label for each label.}

\item{returnData}{Boolean.  Determines if this visualization should return data used to generate the visualization. Default=FALSE.}
}
\value{
If returnData is true, this function will return the long-form table for differentially expressed genes
containing gene names, categorical variable, and expression values.
}
\description{
This function plots the log2 fold-change values for all differentially expressed genes for each contrast in
a result set.  This plot visualizes the distribution and strength of expression changes for all differentially expressed genes.
}
\examples{
\dontrun{

#Prepare a result list.
res.day1 <- results(dds, contrast=c("Condition_Time", "day1_disease", "day1_control"))
res.day2 <- results(dds, contrast=c("Condition_Time", "day2_disease", "day2_control"))
res.day3 <- results(dds, contrast=c("Condition_Time", "day3_disease", "day3_control"))
myResList <- list(res.day1, res.day2, res.day3)

#Create the plot.
de_diverge_plot(res_list=myResList, filename="DE_divergence_plot.pdf",
                 theme=1, returnData=FALSE)

}
}
\keyword{DE}
\keyword{expression}
\keyword{fold-change}
\keyword{visualization}
