% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{write_all_de_results}
\alias{write_all_de_results}
\title{Write differentially expressed gene data for multiple result sets to file.}
\usage{
write_all_de_results(res_list, lfc_filter = FALSE)
}
\arguments{
\item{res_list}{A list of DESeq result sets.}

\item{lfc_filter}{Also impose a filter on the DE set by a minimum absolute log2foldChange as determined by init_cutoffs(). Default=FALSE.}
}
\value{
Output for each result set will be written to file This function does not return a value.
}
\description{
This function accepts a list of DE result sets and writes their outputs individually to file.
Relies on init_cutoffs() significance thresholds. Filenames will be generated automatically based on the contrasts performed
during the results() function. Output will be written to the /DE/data/ folder.
}
\examples{
\dontrun{

#Prepare a result list for aggregation.
res.day1 <- results(dds, contrast=c("Condition_Time", "day1_disease", "day1_control"))
res.day2 <- results(dds, contrast=c("Condition_Time", "day2_disease", "day2_control"))
res.day3 <- results(dds, contrast=c("Condition_Time", "day3_disease", "day3_control"))
myResList <- list(res.day1, res.day2, res.day3)

#Write differentally expressed gene data for each contrast to file.
#Include a minimum fold change filter. This will output 3 files.
write_all_de_results(res_list=myResList, lfc_filter=TRUE)

}
}
\seealso{
\code{\link{init_cutoffs}}, \code{\link{create_dir_struct}}
}
\keyword{DE}
\keyword{contrast}
\keyword{output}
\keyword{result}
