% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moduleGO.R
\name{moduleGO}
\alias{moduleGO}
\title{Perform module GO-trait correlation}
\usage{
moduleGO(genes, labels, universe, HGNC_clean = TRUE, HGNC_switch = TRUE,
  gene_ontology = "all", pval_GO_cutoff = 1, annotation = "org.Hs.eg.db",
  conditional = FALSE, calculateVariance = FALSE)
}
\arguments{
\item{genes}{A character vector specifying gene symbols, present as rows in the inputMat, corresponding to each module label in the labels argument.}

\item{labels}{A character vector specifying module label names, one for each gene symbol in the genes argument, with overlap allowed (i.e., each gene can be in more than one module).}

\item{universe}{Character vector of gene symbols which should be used as the background in the hypergeomtric test. If using this in the context of a DGCA experiment, this gene list most likely should be the gene set post-filtering, but prior to differential correlation analysis.}

\item{HGNC_clean}{Logical indicating whether the input gene symbols should be switched to clean HGNC symbols using the checkGeneSymbols function from the R package HGNChelper. Only applies if HGNC symbols are inputted.}

\item{HGNC_switch}{Logical indicating whether or not the input gene symbols need to be switched from HGNC to Ensembl, the latter of which is required for GOstats enrichment test. Note that this is done by selecting the first Ensembl symbol that maps to a particular HGNC symbol, which is not always unique. If you need more precision on the conversion, you should do this outside of the function and insert the Ensembl list to the function.}

\item{gene_ontology}{A string specifying the branch of GO that should be used for enrichment analysis. One of "BP" (Biological Process), "MF" (Molecular Function), "CC" (Cellular Component), or "all". If "all" is chosen, then this function finds the enrichment for all of the terms and combines them into one table. Default = "all"}

\item{pval_GO_cutoff}{Cutoff for the unadjusted p-values of gene ontology terms in the enrichment tests that should be displayed in the resulting table.}

\item{annotation}{The library indicating the GO annotation database from which the Go terms should be mapped to gene symbols. Default = "org.Hs.eg.db", which is the table for Homo sapiens. Other common choices include "org.Mm.eg.db", "org.Rn.eg.db". The corresponding annotation library needs to be installed.}

\item{conditional}{Logical specifying whether the GO analysis should be done conditionally to take into account the hierarchical structure of the GO database in making sense of the gene set enrichments.}

\item{calculateVariance}{Optionally, find the variance of the odds ratio for each enrichment test. In particular, this finds the standard error of the log odds ratio, which converges to a normal distribution much more quickly than the non-log OR.}
}
\value{
A list of lists of df's, one corresponding to each module, containing GO enrichment information for each module in each of the GO categories selected.
}
\description{
Takes input vectors of gene symbols, labels of corresponding modules, and a universe gene set and leverages the GOstats package to perform GO enrichment analysis.
}

