% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm.R
\name{dlm.lpl}
\alias{dlm.lpl}
\title{Calculate the log predictive likelihood for a specified set of parents and a fixed delta.}
\usage{
dlm.lpl(Yt, Ft, delta, priors = priors.spec())
}
\arguments{
\item{Yt}{the vector of observed time series, length \code{T}.}

\item{Ft}{the matrix of covariates, dim = number of thetas (\code{p}) x number of time
points (\code{T}), usually a row of 1s to represent an intercept and the time series of
the parent nodes.}

\item{delta}{discount factor (scalar).}

\item{priors}{list with prior hyperparameters.}
}
\value{
\item{mt}{the vector or matrix of the posterior mean (location parameter), dim = \code{p x T}.}
\item{Ct}{and \code{CSt} the posterior scale matrix \code{C_{t}} is \code{C_{t} = C*_{t} x S_{t}},
 with dim = \code{p x p x T}, where \code{S_{t}} is a point estimate for the observation variance
 \code{phi^{-1}}}
\item{Rt}{and \code{RSt} the prior scale matrix \code{R_{t}} is \code{R_{t} = R*_{t} x S_{t-1}},
 with dim = \code{p x p x T}, where \code{S_{t-1}} is a point estimate for the observation
 variance \code{phi^{-1}} at the previous time point.}
\item{nt}{and \code{dt} the vectors of the updated hyperparameters for the precision \code{phi}
 with length \code{T}.}
\item{S}{the vector of the point estimate for the observation variance \code{phi^{-1}} with
 length \code{T}.}
\item{ft}{the vector of the one-step forecast location parameter with length \code{T}.}
\item{Qt}{the vector of the one-step forecast scale parameter with length \code{T}.}
\item{ets}{the vector of the standardised forecast residuals with length \code{T},
 \eqn{\newline} defined as \code{(Y_{t} - f_{t}) / sqrt (Q_{t})}.}
\item{lpl}{the vector of the Log Predictive Likelihood with length \code{T}.}
}
\description{
Calculate the log predictive likelihood for a specified set of parents and a fixed delta.
}
\examples{
data("utestdata")
Yt = myts[,1]
Ft = t(cbind(1,myts[,2:5]))
m = dlm.lpl(Yt, Ft, 0.7)


}
\references{
West, M. & Harrison, J., 1997. Bayesian Forecasting and Dynamic Models. Springer New York.
}
