% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{hist.DHARMa}
\alias{hist.DHARMa}
\title{Histogram of DHARMa residuals}
\usage{
\method{hist}{DHARMa}(x, breaks = seq(-0.02, 1.02, len = 53),
  col = c("red", rep("lightgrey", 50), "red"),
  main = "Hist of DHARMa residuals",
  xlab = "Residuals (outliers are marked red)", cex.main = 1, ...)
}
\arguments{
\item{x}{a DHARMa simulation output (class DHARMa)}

\item{breaks}{breaks for hist() function}

\item{col}{col for hist bars}

\item{main}{plot main}

\item{xlab}{plot xlab}

\item{cex.main}{plot cex.main}

\item{...}{other arguments to be passed on to hist}
}
\description{
The function produces a histogram from a DHARMa output
}
\examples{
testData = createData(sampleSize = 200, family = poisson(), 
                      randomEffectVariance = 1, numGroups = 10)
fittedModel <- glm(observedResponse ~ Environment1, 
                   family = "poisson", data = testData)
simulationOutput <- simulateResiduals(fittedModel = fittedModel)

######### main plotting function #############

# for all functions, quantreg = T will be more
# informative, but slower

plot(simulationOutput, quantreg = FALSE)

#############  Distribution  ######################

plotQQunif(simulationOutput = simulationOutput, 
           testDispersion = FALSE,
           testUniformity = FALSE,
           testOutliers = FALSE)

hist(simulationOutput )

#############  residual plots  ###############

# rank transformation, using a simulationOutput
plotResiduals(simulationOutput, rank = TRUE, quantreg = FALSE)

# smooth scatter plot - usually used for large datasets, default for n > 10000
plotResiduals(simulationOutput, rank = TRUE, quantreg = FALSE, smoothScatter = TRUE)

# residual vs predictors, using explicit values for pred, residual 
plotResiduals(simulationOutput, form = testData$Environment1, 
              quantreg = FALSE)

# if pred is a factor, or if asFactor = T, will produce a boxplot
plotResiduals(simulationOutput, form = testData$group)

# All these options can also be provided to the main plotting function

# If you want to plot summaries per group, use
simulationOutput = recalculateResiduals(simulationOutput, group = testData$group)
plot(simulationOutput, quantreg = FALSE) 
# we see one residual point per RE


}
\seealso{
\code{\link{plotSimulatedResiduals}}, \code{\link{plotResiduals}}
}
