% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_replacements.R
\name{string_replacements}
\alias{string_replacements}
\title{Clean string with a given set of replacements}
\usage{
string_replacements(
  input,
  replace_mapping = "default",
  tolower = FALSE,
  toupper = FALSE
)
}
\arguments{
\item{input}{(string) The character string to be processed.}

\item{replace_mapping}{(Optional, list, default = "default") The mapping
containing what should be replaced with what:
`replace_mapping <- list("replace_this" = "with_this")`}

\item{tolower}{(boolean, default = FALSE) Should the result be lowercase?}

\item{toupper}{(boolean, default = FALSE) Should the result be uppercase?}
}
\value{
(String) All elements (names) of the input `replace_mapping` or
  the default mapping are replaced by its values of the mapping.
}
\description{
This function provides the functionality to clean a string
  with a given set of replacements. This is e.g. useful to create
  filenames or paths that are not allowed to contain spaces.
}
\examples{
string_replacements(input = "Ab 20. April 2020 (((___((N = 1.234)")
# Result: "Ab_20_April_2020_N_1234"

}
