% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_to_R_env.R
\name{assign_to_R_env}
\alias{assign_to_R_env}
\title{Add variable to R environment (in contrast to system environment).}
\usage{
assign_to_R_env(key, val, pos = 1)
}
\arguments{
\item{key}{A character (!) string. The name of the assigned variable}

\item{val}{An object. The object that will be assigned to 'key'.}

\item{pos}{An integer. The position of the environment (default: 1).}
}
\value{
No return value, called for side effects (see description).
}
\description{
Hack variable into global env (bypasses R CMD checks).
  This does create a new variable in the R environment but NOT a new
  variable in the system environment. To create a system environment
  variable being accessible via `Sys.getenv(...)`, use the function
  `DIZtools::setenv2(key = "varname", val = 7)`.
  Old function name: `global_env_hack()`
}
\examples{
utils_path <- tempdir()
assign_to_R_env(
  key = "utils_path",
  val = utils_path,
  pos = 1L
)

}
\seealso{
\url{http://adv-r.had.co.nz/Environments.html}
}
