% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IOTC.R
\name{IOTC_plot}
\alias{IOTC_plot}
\title{Indian Ocean Tuna Commission trade-off plot}
\usage{
IOTC_plot(MSEobj, Bref = 0.75, Yref = 0.75, Bsat = 0.8, Ysat = 0.8,
  xlim = c(0, 1.1), ylim = c(0, 1.1))
}
\arguments{
\item{MSEobj}{An object of class MSE created by the function runMSE()}

\item{Bref}{A biomass reference level (an improper fraction of BMSY)}

\item{Yref}{A yield reference level (an improper fraction of yield given FMSY management)}

\item{Bsat}{The satisficing level for biomass (required fraction of simulations exceeding Bref)}

\item{Ysat}{The satisficing level for yield (required fraction of simulations exceeding Yref)}

\item{xlim}{The limits of the x axis plotting}

\item{ylim}{The limits of the y axis plotting}
}
\description{
A one-panel trade-off plot showing the probability of exceeding a biomass reference level
and a yield reference level
}
\author{
T. Carruthers
}
