% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMSE_old.R
\name{runMSE_old}
\alias{runMSE_old}
\title{Run a Management Strategy Evaluation}
\usage{
runMSE_old(OM = DLMtool::testOM, MPs = c("AvC", "DCAC", "FMSYref", "curE",
  "matlenlim"), nsim = 48, proyears = 50, interval = 4, pstar = 0.5,
  maxF = 0.8, timelimit = 1, reps = 1, CheckMPs = FALSE, Hist = FALSE,
  ntrials = 50, fracD = 0.05, CalcBlow = FALSE, HZN = 2, Bfrac = 0.5)
}
\arguments{
\item{OM}{An operating model object (class OM)}

\item{MPs}{A vector of methods (character string) of class Output or
Input.}

\item{nsim}{Number of simulations. Note that in DLMtool V4.1+ 'nsim is ignored 
if OM object contains the slot 'nsim'.}

\item{proyears}{Number of projected years. Note that in DLMtool V4.1+ 'proyears is ignored 
if OM object contains the slot 'proyears'.}

\item{interval}{The assessment interval - how often would you like to update
the management system?}

\item{pstar}{The percentile of the sample of the management recommendation
for each method}

\item{maxF}{Maximum instantaneous fishing mortality rate that may be
simulated for any given age class}

\item{timelimit}{Maximum time taken for a method to carry out 10 reps
(methods are ignored that take longer)}

\item{reps}{Number of samples of the management recommendation for each
method. Note that when this is set to 1, the mean value of the data inputs
is used.}

\item{CheckMPs}{Logical to indicate if Can function should be used to check
if MPs can be run.}

\item{Hist}{Should model stop after historical simulations? Returns a list 
containing all historical data}

\item{ntrials}{Maximum of times depletion and recruitment deviations are 
resampled to optimize for depletion. After this the model stops if more than 
percent of simulations are not close to the required depletion}

\item{fracD}{maximum allowed proportion of simulations where depletion is not 
close to sampled depletion from OM before model stops with error}

\item{CalcBlow}{Should low biomass be calculated where this is the spawning
biomass at which it takes HZN mean generation times of zero fishing to reach 
Bfrac fraction of SSBMSY}

\item{HZN}{The number of mean generation times required to reach Bfrac SSBMSY
in the Blow calculation}

\item{Bfrac}{The target fraction of SSBMSY for calculating Blow}
}
\value{
An object of class MSE
}
\description{
A function that runs a Management Strategy Evaluation (closed-loop
simulation) for a specified operating model
}
\author{
T. Carruthers and A. Hordyk
}
