% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineClasses.r
\docType{class}
\name{MSE-class}
\alias{MSE-class}
\title{Class \code{'MSE'}}
\description{
A Management Strategy Evaluation object that contains information about
simulation conditions and performance of data-limited methods
}
\section{Slots}{

\describe{
\item{\code{Name}}{Name of the MSE object. Single value. Character string}

\item{\code{nyears}}{The number of years for the historical simulation. Single value. Positive integer}

\item{\code{proyears}}{The number of years for the projections - closed loop simulations. Single value. Positive integer}

\item{\code{nMPs}}{Number of management procedures simulation tested. Single value. Positive integer.}

\item{\code{MPs}}{The names of the MPs that were tested. Vector of length nMPs. Character strings.}

\item{\code{nsim}}{Number of simulations. Single value. Positive integer}

\item{\code{OM}}{A table of sampled parameter of the operating model. Table object of nsim rows. Real numbers\cr
\itemize{

\item A: abundance (biomass) updated in each management update of projection

\item AC: autocorrelation in recruitment

\item ageM: age at 50 per cent maturity

\item B0: unfished total biomass

\item Blow: SSB where it takes MGThorizon x MGT to reach Bfrac of BMSY (spawning biomass)

\item BMSY: BMSY in last historical year (total biomass)

\item BMSY_B0: ratio of BMSY to unfished total biomass in last historical year

\item Depletion: stock depletion (spawning biomass / unfished spawing biomass) in the final historical year (prior to projection)

\item dFfinal: gradient in fishing mortality rate over final five years of the historical simulation

\item DR: the fraction of caught fish that are discarded

\item Esd: inter-annual variability in fishing mortality rate

\item Fdisc: fraction of discarded fish that die

\item FMSY: fishing mortality at MSY in last historical year

\item FMSY_M: ratio of FMSY to M in last historical year

\item Frac_area_1: fraction of the unfished biomass in stock 1

\item hs: steepness of the stock recruitment relationship (the fraction of unfished recruitment at a fifth of unfished stock levels)

\item K: maximum growth rate (von Bertalanffy K parameter)

\item Kgrad: mean gradient in maximum growth rate (per cent per time step)

\item Ksd: interannual variability in maximum growth rate (log normal CV)

\item L5: length at 5/% selectivity

\item L50: length at 50/% maturity

\item L95: length at 95/% maturity

\item LFC: length at first capture

\item LFR: first length at full retention

\item LFS: first length at full selection

\item Linf: asymptotic length

\item Linfgrad: mean gradient in maximum length (per cent per time step)

\item Linfsd: interannual variability in maximum length (log normal CV)

\item LR5: first length at 5/% retention

\item M: instantaneous natural mortality rate

\item Mexp: exponent of Lorezen M-weight relationship

\item Mgrad: mean average percentage gradient in natural mortality rate (percentage per time step)

\item MGT: mean generation time

\item Msd: interannual variability in natural mortality rate (lognormal CV)

\item MSY: maximum sustainable yield in last historical year

\item N0: equilibrium unfished total numbers

\item OFLreal: A * FMSY  the true simulated Over Fishing Limit in last historical year

\item Prob_staying: probability of inviduals in area 1 remaining in area 1 over the course of one year

\item procsd: process error - CV in log-normal recruitment deviations

\item qcv: interannual variability in future fishing efficiency (catchability) in projected years (input controls only)

\item qinc: mean percentage increase in fishing efficiency (catchability) in projected years (input controls only)

\item RefY: reference yield, the highest long-term yield (mean over last five years of projection) obtained from a fixed F strategy. This is a useful reference point for framing performance of MPs because it standardizes for starting point and future productivity.

\item Rmaxlen: retention of fish at asymptotic length

\item Size_area_1: size of Area 1 relative to Area 2

\item SizeLimFrac: fraction of average implementation error of size regulations

\item SizeLimSD: log-normal coefficient of variation controlling mismatch between a minimum size limit and the real minimum size retained.

\item Spat_targ: distribution of fishing in relation to spatial biomass: fishing distribution is proportional to B^Spat_targ

\item SSB0: unfished spawning biomass

\item SSBMSY: spawning biomass MSY in last historical year

\item SSBMSY_SSB0: ratio of SSB[MSY]/SSB0 in last historical year

\item t0: theoretical length at age zero (von Bertalanffy t0 parameter)

\item TACFrac: mean fraction of TAC taken

\item TACSD: log-normal coefficient of variation in the fraction of Total Allowable Catch (TAC) taken

\item TAEFrac: mean fraction of TAE taken

\item TAESD: log-normal coefficient of variation in the fraction of TAE

\item Vmaxlen: selection of fish at asymptotic length

}}

\item{\code{Obs}}{A table of sampled parameters of the observation model. Table of nsim rows. Real numbers\cr
\itemize{

\item Abias: bias in observed current absolute stock biomass

\item Aerr: error in observed current absolute stock biomass

\item betas: hyper-stability/hyper-depletion parameter

\item BMSY_B0bias: bias in ratio of most productive stock size relative to unfished

\item Brefbias: bias in BMSY stock levels (target or reference biomass levels)

\item CAA_ESS: the effective sample size of multinomial catch-at-age observation model (number of independent draws)

\item CAA_nsamp: the number of catch-at-age observations per time step

\item CAL_ESS: the effective sample size of multinomial catch-at-length observation model (number of independent draws)

\item CAL_nsamp: the number of catch-at-length observations per time step

\item Cbias: bias in observed catches

\item Crefbias: bias in MSY prediction (target or reference catch)

\item Csd: observation error in observed catches (lognormal CV)

\item Dbias: bias in observed stock depletion (also applies to depletion Dt for DCAC)

\item Derr: error in observed stock depletion

\item FMSY_Mbias: bias in ratio of FMSY to natural mortality rate

\item hbias: bias in observed steepness of the stock recruitment relationship

\item Irefbias: bias in abundance index corresponding to BMSY stock levels

\item Isd: observation error in relative abundance index (lognormal CV)

\item Kbias: bias in maximum growth rate (von Bertalanffy K parameter)

\item lenMbias: bias in length at 50 per cent maturity

\item LFCbias: bias in length at first capture

\item LFSbias: bias in length at full selection

\item Linfbias: bias in maximum length (von Bertalanffy Linf parameter)

\item Mbias: bias in observed natural mortality rate

\item Recsd: error in observed recruitment

\item t0bias: bias in theoretical length at age zero (von Bertalanffy t0 parameter)

}}

\item{\code{B_BMSY}}{Simulated biomass relative to BMSY over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{F_FMSY}}{Simulated fishing mortality rate relative to FMSY over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{B}}{Simulated stock biomass over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{SSB}}{Simulated spawning stock biomass over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{VB}}{Simulated vulnerable biomass over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{FM}}{Simulated fishing mortality rate over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{C}}{Simulated catches (taken) over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{TAC}}{Simulated Total Allowable Catch (prescribed) over the projection (this is NA for input controls). An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{SSB_hist}}{Simulated historical spawning stock biomass. An array with dimensions: nsim, nages, nyears, nareas. Non-negative real numbers}

\item{\code{CB_hist}}{Simulated historical catches in weight. An array with dimensions: nsim, nages, nyears, nareas. Non-negative real numbers}

\item{\code{FM_hist}}{Simulated historical fishing mortality rate. An array with dimensions: nsim, nages, nyears, nareas. Non-negative real numbers}

\item{\code{Effort}}{Simulated relative fishing effort in the projection years. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{PAA}}{Population at age in last projection year. An array with dimensions: nsim, nMPs, nages. Non-negative real numbers}

\item{\code{CAA}}{Catch at age in last projection year. An array with dimensions: nsim, nMPs, nages. Non-negative real numbers}

\item{\code{CAL}}{Catch at length in last projection year. An array with dimensions: nsim, nMPs, nCALbins. Non-negative real numbers}

\item{\code{CALbins}}{Mid-points of the catch-at-length bins. Vector of length nCALbins. Positive real numbers.}

\item{\code{Misc}}{Miscellanenous output such as posterior predictive data}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('MSE', Name, nyears, proyears, nMPs, MPs, nsim, OMtable, Obs,
B_BMSYa, F_FMSYa, Ba, FMa, Ca, OFLa, Effort, PAA, CAA, CAL, CALbins)}
}

\author{
T. Carruthers
}
\keyword{classes}
