% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineClasses.r
\docType{class}
\name{OM-class}
\alias{OM-class}
\title{Class \code{'OM'}}
\description{
An object containing all the parameters needed to control the MSE which can
be build from component Stock, Fleet, Obs, and Imp objects.
}
\details{
Almost all of these inputs are a vector of length 2 which describes the upper and lower
bounds of a uniform distribution from which to sample the parameter.
}
\section{Slots}{

\describe{
\item{\code{Name}}{Name of the operating model}

\item{\code{Agency}}{Name of the agency responsible for the management of the fishery. Character string}

\item{\code{Region}}{Name of the general geographic region of the fishery. Character string}

\item{\code{Sponsor}}{Name of the organization who sponsored the OM. Character string}

\item{\code{Latitude}}{Latitude (decimal degrees). Negative values represent the South of the Equator. Numeric. Single value}

\item{\code{Longitude}}{Longitude (decimal degrees). Negative values represent the West of the Prime Meridian. Numeric. Single value}

\item{\code{nsim}}{The number of simulations}

\item{\code{proyears}}{The number of projected years}

\item{\code{interval}}{The assessment interval - how often would you like to update the management system?}

\item{\code{pstar}}{The percentile of the sample of the management recommendation for each method}

\item{\code{maxF}}{Maximum instantaneous fishing mortality rate that may be simulated for any given age class}

\item{\code{reps}}{Number of samples of the management recommendation for each method. Note that when this is set to 1, the mean value of
the data inputs is used.}

\item{\code{cpars}}{A list of custom parameters. Time series are a matrix nsim rows by nyears columns. Single parameters are a vector nsim long}

\item{\code{seed}}{A random seed to ensure users can reproduce results exactly}

\item{\code{Source}}{A reference to a website or article from which parameters were taken to define the operating model}

\item{\code{Common_Name}}{Common name of the species. Character string}

\item{\code{Species}}{Scientific name of the species. Genus and species name. Character string}

\item{\code{maxage}}{The maximum age of individuals that is simulated (there is no 'plus group'). Single value. Positive integer}

\item{\code{R0}}{The magnitude of unfished recruitment. Single value. Positive real number}

\item{\code{M}}{Natural mortality rate. Uniform distribution lower and upper bounds. Positive real number}

\item{\code{M2}}{(Optional) Natural mortality rate at age. Vector of length 'maxage'. Positive real number}

\item{\code{Mexp}}{Exponent of the Lorenzen function assuming an inverse relationship between M and weight. Uniform distribution lower and upper bounds. Real numbers <= 0.}

\item{\code{Msd}}{Inter-annual variability in natural mortality rate expressed as a coefficient of variation. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Mgrad}}{Mean temporal trend in natural mortality rate, expressed as a percentage change in M per year. Uniform distribution lower and upper bounds. Real numbers}

\item{\code{h}}{Steepness of the stock recruit relationship. Uniform distribution lower and upper bounds. Values from 1/5 to 1}

\item{\code{SRrel}}{Type of stock-recruit relationship. Single value, switch (1) Beverton-Holt (2) Ricker. Integer}

\item{\code{Perr}}{Process error, the CV of lognormal recruitment deviations. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{AC}}{Autocorrelation in recruitment deviations rec(t)=AC*rec(t-1)+(1-AC)*sigma(t). Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Period}}{(Optional) Period for cyclical recruitment pattern in years. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Amplitude}}{(Optional) Amplitude in deviation from long-term average recruitment during recruitment cycle (eg a range from 0 to 1 means recruitment decreases or increases by up to 100\% each cycle). Uniform distribution lower and upper bounds. 0 < Amplitude < 1}

\item{\code{Linf}}{Maximum length. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{K}}{von Bertalanffy growth parameter k. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{t0}}{von Bertalanffy theoretical age at length zero. Uniform distribution lower and upper bounds. Non-positive real numbers}

\item{\code{LenCV}}{Coefficient of variation of length-at-age (assumed constant for all age classes). Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Ksd}}{Inter-annual variability in growth parameter k. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Kgrad}}{Mean temporal trend in growth parameter k, expressed as a percentage change in k per year. Uniform distribution lower and upper bounds. Real numbers}

\item{\code{Linfsd}}{Inter-annual variability in maximum length. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Linfgrad}}{Mean temporal trend in maximum length, expressed as a percentage change in Linf per year. Uniform distribution lower and upper bounds. Real numbers}

\item{\code{L50}}{Length at 50 percent maturity. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{L50_95}}{Length increment from 50 percent to 95 percent maturity. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{D}}{Current level of stock depletion SSB(current)/SSB(unfished). Uniform distribution lower and upper bounds. Fraction}

\item{\code{a}}{Length-weight parameter alpha. Single value. Positive real number}

\item{\code{b}}{Length-weight parameter beta. Single value. Positive real number}

\item{\code{Size_area_1}}{The size of area 1 relative to area 2. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Frac_area_1}}{The fraction of the unfished biomass in stock 1. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Prob_staying}}{The probability of inviduals in area 1 remaining in area 1 over the course of one year. Uniform distribution lower and upper bounds. Positive fraction.}

\item{\code{Fdisc}}{Fraction of discarded fish that die. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{nyears}}{The number of years for the historical 'spool-up' simulation. Single value. Positive integer}

\item{\code{Spat_targ}}{Distribution of fishing in relation to spatial biomass: fishing distribution is proportional to B^Spat_targ. Uniform distribution lower and upper bounds. Real numbers}

\item{\code{EffYears}}{Years representing join-points (vertices) of time-varying effort. Vector. Non-negative real numbers}

\item{\code{EffLower}}{Lower bound on relative effort corresponding to EffYears. Vector. Non-negative real numbers}

\item{\code{EffUpper}}{Upper bound on relative effort corresponding to EffYears. Vector. Non-negative real numbers}

\item{\code{Esd}}{Additional inter-annual variability in fishing mortality rate. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{qinc}}{Average percentage change in fishing efficiency (applicable only to forward projection and input controls). Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{qcv}}{Inter-annual variability in fishing efficiency (applicable only to forward projection and input controls). Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{L5}}{Shortest length corresponding to 5 percent vulnerability. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{LFS}}{Shortest length that is fully vulnerable to fishing. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Vmaxlen}}{The vulnerability of fish at Stock@Linf. Uniform distribution lower and upper bounds. Fraction}

\item{\code{isRel}}{Selectivity parameters in units of size-of-maturity (or absolute eg cm). Single value. Boolean.}

\item{\code{LR5}}{Shortest length corresponding ot 5 percent retention. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{LFR}}{Shortest length that is fully retained. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Rmaxlen}}{The retention of fish at Stock@Linf. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{DR}}{Discard rate - the fraction of caught fish that are discarded. Uniform distribution lower and upper bounds. Fraction}

\item{\code{SelYears}}{(Optional) Years representing join-points (vertices) at which historical selectivity pattern changes. Vector. Positive real numbers}

\item{\code{AbsSelYears}}{(Optional) Calendar years corresponding with SelYears (eg 1951, rather than 1), used for plotting only. Vector (of same length as SelYears). Positive real numbers}

\item{\code{L5Lower}}{(Optional) Lower bound of L5 (use \code{ChooseSelect} function to set these). Vector. Non-negative real numbers}

\item{\code{L5Upper}}{(Optional) Upper bound of L5 (use \code{ChooseSelect} function to set these). Vector. Non-negative real numbers}

\item{\code{LFSLower}}{(Optional) Lower bound of LFS (use \code{ChooseSelect} function to set these). Vector. Non-negative real numbers}

\item{\code{LFSUpper}}{(Optional) Upper bound of LFS (use \code{ChooseSelect} function to set these). Vector. Non-negative real numbers}

\item{\code{VmaxLower}}{(Optional) Lower bound of Vmaxlen (use \code{ChooseSelect} function to set these). Vector. Fraction}

\item{\code{VmaxUpper}}{(Optional) Upper bound of Vmaxlen (use \code{ChooseSelect} function to set these). Vector. Fraction}

\item{\code{CurrentYr}}{The current calendar year (final year) of the historical simulations (eg 2011). Single value. Positive integer. .}

\item{\code{MPA}}{(Optional) Matrix specifying spatial closures for historical years. Each row should contain year index (e.g 10 for 10th historical year)
followed by fraction of area closed to fishing for each area. i.e. each row represents a change and the number of columns is nareas + 1.
The spatial closures are assumed to remain in place for the future projections unless changed by a MP.
Default (if left blank) is all areas are open to fishing in historical period.}

\item{\code{Cobs}}{Log-normal catch observation error expressed as a coefficient of variation. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{Cbiascv}}{Log-normal coefficient of variation controlling the sampling of bias in catch observations for each simulation. Uniform distribution lower and upper bounds. Non-negative real numbers}

\item{\code{CAA_nsamp}}{Number of catch-at-age observation per time step. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{CAA_ESS}}{Effective sample size (independent age draws) of the multinomial catch-at-age observation error model. Uniform distribution lower and upper bounds. Positive integers}

\item{\code{CAL_nsamp}}{Number of catch-at-length observation per time step. Uniform distribution lower and upper bounds. Positive integers}

\item{\code{CAL_ESS}}{Effective sample size (independent length draws) of the multinomial catch-at-length observation error model. Uniform distribution lower and upper bounds. Positive integers}

\item{\code{Iobs}}{Observation error in the relative abundance indices expressed as a coefficient of variation. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Ibiascv}}{NOT CURRENTLY USED Log-normal coefficient of variation controlling error in observations of relative abundance index. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Btobs}}{Log-normal coefficient of variation controlling error in observations of current stock biomass among years. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Btbiascv}}{Uniform-log bounds for sampling persistent bias in current stock biomass. Uniform-log distribution lower and upper bounds. Positive real numbers}

\item{\code{beta}}{A parameter controlling hyperstability/hyperdepletion where values below 1 lead to hyperstability (an index that decreases slower than true abundance) and values above 1 lead to hyperdepletion (an index that decreases more rapidly than true abundance). Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{LenMbiascv}}{Log-normal coefficient of variation for sampling persistent bias in length at 50 percent maturity. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Mbiascv}}{Log-normal coefficient of variation for sampling persistent bias in observed natural mortality rate. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Kbiascv}}{Log-normal coefficient of variation for sampling persistent bias in observed growth parameter K. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{t0biascv}}{Log-normal coefficient of variation for sampling persistent bias in observed t0. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Linfbiascv}}{Log-normal coefficient of variation for sampling persistent bias in observed maximum length. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{LFCbiascv}}{Log-normal coefficient of variation for sampling persistent bias in observed length at first capture. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{LFSbiascv}}{Log-normal coefficient of variation for sampling persistent bias in length-at-full selection. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{FMSYbiascv}}{Log-normal coefficient of variation for sampling persistent bias in FMSY. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{FMSY_Mbiascv}}{Log-normal coefficient of variation for sampling persistent bias in FMSY/M. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{BMSY_B0biascv}}{Log-normal coefficient of variation for sampling persistent bias in BMSY relative to unfished. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Irefbiascv}}{Log-normal coefficient of variation for sampling persistent bias in relative abundance index at BMSY. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Brefbiascv}}{Log-normal coefficient of variation for sampling persistent bias in BMSY. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Crefbiascv}}{Log-normal coefficient of variation for sampling persistent bias in MSY. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Dbiascv}}{Log-normal coefficient of variation for sampling persistent bias in stock depletion. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Dobs}}{Log-normal coefficient of variation controlling error in observations of stock depletion among years. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{hbiascv}}{Log-normal coefficient of variation for sampling persistent bias in steepness. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{Recbiascv}}{Log-normal coefficient of variation for sampling persistent bias in recent recruitment strength. Uniform distribution lower and upper bounds. Positive real numbers}

\item{\code{TACFrac}}{Mean fraction of TAC taken. Uniform distribution lower and upper bounds. Positive real number.}

\item{\code{TACSD}}{Log-normal coefficient of variation in the fraction of Total Allowable Catch (TAC) taken. Uniform distribution lower and upper bounds. Non-negative real numbers.}

\item{\code{TAEFrac}}{Mean fraction of TAE taken. Uniform distribution lower and upper bounds. Positive real number.}

\item{\code{TAESD}}{Log-normal coefficient of variation in the fraction of Total Allowable Effort (TAE) taken. Uniform distribution lower and upper bounds. Non-negative real numbers.}

\item{\code{SizeLimFrac}}{The real minimum size that is retained expressed as a fraction of the size. Uniform distribution lower and upper bounds. Positive real number.}

\item{\code{SizeLimSD}}{Log-normal coefficient of variation controlling mismatch between a minimum size limit and the real minimum size retained. Uniform distribution lower and upper bounds. Non-negative real numbers.}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('OM', Stock, Fleet, Obs, Imp)}.
}

\author{
T. Carruthers and A. Hordyk
}
\keyword{classes}
