% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/DNMF.R
\name{DNMF}
\alias{DNMF}
\title{Discrimant Non-Negative Matrix Factorization.}
\usage{
DNMF(data, trainlabel, r = 2, gamma = 0.1, delta = 1e-04,
  maxIter = 1000, tol = 1e-07, plotit = FALSE, checkH = TRUE)
}
\arguments{
\item{data}{a matrix, like expression profilings of some samples. the columns are samples and the rows are gene's expression.}

\item{trainlabel}{a numeric vector of sample type of all the samples, this vector should ONLY contain 1 and 2 so far and length of it should equal the column (sample) size of data.}

\item{r}{the dimension of expected reduction dimension, with the default value 2.}

\item{gamma}{the tradeoff value for the within scatter matrix, with the default value 0.1.}

\item{delta}{the tradeoff value for the between scatter matrix, with the default value 1e-4.}

\item{maxIter}{the maximum iteration of update rules, with the default value 1000.}

\item{tol}{the toleration of coverange, with the default value 1e-7.}

\item{plotit}{whether plot H (V=WH). Default: FALSE.}

\item{checkH}{whether or not check H. Default: TRUE. This parameter aims to
check whether or not the H safisfy the discriminant metagenes. Usually, this
should be TRUE.}
}
\description{
Discrimant Non-Negative Matrix Factorization, DNMF, is to extend the Non-negative Matrix Factorization algorithm in
order to extract features that enforce not only the spatial locality, but
 also the separability between classes in a discriminant manner.
}
\details{
The main algorithm is based on
\href{http://www.ncbi.nlm.nih.gov/pubmed/16722172}{Zafeiriou, S., et al.
(2006) Exploiting discriminant information in
nonnegative matrix factorization with application to frontal face
verification, IEEE transactions on neural networks, 17, 683-695},
with some \strong{CORRECTIONs}.
}
\examples{
r =2
data =  matrix(1:12,3,4)
trainlabel = c(1,1,2,2)
DNMF_result <- DNMF(data, trainlabel, r, plotit=FALSE, checkH=FALSE)

\dontrun{
DNMF_result <- DNMF(data, trainlabel, r)
DNMF_result <- DNMF(data, trainlabel, r=2, gamma=0.1, delta=0.0001, plotit=TRUE)
}
}

