% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_utils.R
\name{test_connection_button_clicked}
\alias{test_connection_button_clicked}
\title{Checks if an connection can be established to the system.}
\usage{
test_connection_button_clicked(
  rv,
  source_target,
  db_type,
  input,
  output,
  session
)
}
\arguments{
\item{rv}{The global 'reactiveValues()' object, defined in server.R}

\item{source_target}{(String) "source" or "target"}

\item{db_type}{(String) "postgres" or "oracle"}

\item{input}{Shiny server input object}

\item{output}{Shiny server output object}

\item{session}{Shiny session object}
}
\value{
true if the connection could be established and false otherwise
  (also if an error occurred)
}
\description{
After the button "Check connection" is pressed in the GUI,
  this function will be called and tries to connect to this system
  and feedbacks the result to the user.
  If the connection is successfully established, the button will be
  disabled and this connection will be stored as valid for the given
  source/target system.
}
