context("drcfit_model")
test_that("drcfit works as expected on the model results",
  {
    skip_on_cran()
    skip_on_os(c("mac", "linux", "solaris"))

    datafilename <- system.file("extdata", "transcripto_sample.txt", package="DRomics")
    o <- microarraydata(datafilename, check = TRUE, norm.method = "cyclicloess")
    s_quad <- itemselect(o, select.method = "quadratic", FDR = 0.001)
    f <- drcfit(s_quad, progressbar = TRUE, information.criterion = "AIC")
    tmodel <- table(f$fitres$model)
    expect_equal(as.numeric(tmodel["Hill"]), 2)
    expect_equal(as.numeric(tmodel["linear"]), 9)
    expect_equal(as.numeric(tmodel["exponential"]), 28)
    expect_equal(as.numeric(tmodel["Gauss-probit"]), 25)
    expect_equal(as.numeric(tmodel["log-Gauss-probit"]), 3)
    expect_equal(round(mean(f$fitres$b, na.rm = TRUE), 4), 1.4656)
    expect_equal(round(mean(f$fitres$c, na.rm = TRUE), 4), 5.3354)
    expect_equal(round(mean(f$fitres$d, na.rm = TRUE), 4), 9.2984)
    expect_equal(round(mean(f$fitres$e, na.rm = TRUE), 4), 1.608)
    expect_equal(round(mean(f$fitres$f, na.rm = TRUE), 4), 2.5344)
    #Select model with BIC
    f.BIC <- drcfit(s_quad, progressbar = TRUE, information.criterion = "BIC")
    tmodel.BIC <- table(f.BIC$fitres$model)
    expect_equal(as.numeric(tmodel.BIC["Hill"]), 0)
    expect_equal(as.numeric(tmodel.BIC["linear"]), 15)
    expect_equal(as.numeric(tmodel.BIC["exponential"]), 26)
    expect_equal(as.numeric(tmodel.BIC["Gauss-probit"]), 23)
    expect_equal(as.numeric(tmodel.BIC["log-Gauss-probit"]), 3)
    #Select model with AICc
    f.AICc <- drcfit(s_quad, progressbar = TRUE, information.criterion = "AICc")
    tmodel.AICc <- table(f.AICc$fitres$model)
    expect_equal(as.numeric(tmodel.AICc["Hill"]), 0)
    expect_equal(as.numeric(tmodel.AICc["linear"]), 11)
    expect_equal(as.numeric(tmodel.AICc["exponential"]), 30)
    expect_equal(as.numeric(tmodel.AICc["Gauss-probit"]), 23)
    expect_equal(as.numeric(tmodel.AICc["log-Gauss-probit"]), 3)
    expect_equal(round(mean(f.AICc$fitres$b, na.rm = TRUE), 4), 1.2561)
    expect_equal(round(mean(f.AICc$fitres$c, na.rm = TRUE), 4), 4.5015)
    expect_equal(round(mean(f.AICc$fitres$d, na.rm = TRUE), 4), 9.2571)
    expect_equal(round(mean(f.AICc$fitres$e, na.rm = TRUE), 4), 1.5162)
    expect_equal(round(mean(f.AICc$fitres$f, na.rm = TRUE), 4), 2.8576)
    
  })