% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_idpatterns.R
\name{simulate_idpatterns}
\alias{simulate_idpatterns}
\title{Simulation of a compartmental infectious disease transmission model including seasonality}
\usage{
simulate_idpatterns(S0 = 1000, P0 = 1, timeunit = 1, tmax = 300,
  bP = 0, bA = 0, bI = 1/1000, gP = 0.5, gA = 0.5, gI = 0.5,
  f = 0, d = 0, w = 0, m = 0, n = 0, s = 0)
}
\arguments{
\item{S0}{specifies the initial number of susceptible hosts}

\item{P0}{initial number of infected, pre-symptomatic hosts,}

\item{timeunit}{units of time in which the model should run, needs to be one of (1=day,2=week,3=month,4=year)}

\item{tmax}{maximum simulation time, in units of months}

\item{bP}{level/rate of infectiousness for hosts in the P compartment}

\item{bA}{level/rate of infectiousness for hosts in the A compartment}

\item{bI}{level/rate of infectiousness for hosts in the I compartment}

\item{gP}{rate at which a person leaves the P compartment, which
is the inverse of the average time spent in that compartment}

\item{gA}{rate at which a person leaves the A compartment}

\item{gI}{rate at which a person leaves the I compartment}

\item{f}{fraction of pre-symptomatic individuals that have an asymptomatic infection}

\item{d}{fraction of symptomatic infected hosts that die due to disease}

\item{w}{rate at which recovered persons loose immunity and return to susceptible state}

\item{m}{the rate at which new individuals enter the model (are born)}

\item{n}{the rate of natural death (the inverse it the average lifespan)}

\item{s}{strength of seasonal/annual sigmoidal variation of transmission rate}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver
}
\description{
Simulation of a compartmental model with several different compartments:
  Susceptibles (S), Infected and Pre-symptomatic (P),
  Infected and Asymptomatic (A), Infected and Symptomatic (I),
  Recovered and Immune (R) and Dead (D).

  This model includes natural births and deaths and waning immunity.
  It also allows for seasonal variation in transmission.
  The model is assumed to run in units of months.
  This assumption is hard-coded into the sinusoidally varying
  transmission coefficient, which is assumed to have a period of a year
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. have I0 > PopSize or any negative values or fractions > 1),
  the code will likely abort with an error message
}

\examples{
  # To run the simulation with default parameters just call this function
  result <- simulate_idpatterns()
  # To choose parameter values other than the standard one, specify them e.g. like such
  result <- simulate_idpatterns(S0 = 2000, P0 = 10, tmax = 100, f = 0.1, d = 0.2, s = 0.1)
  # You should then use the simulation result returned from the function, e.g. like this:
  plot(result[,1],result[,2],xlab='Time',ylab='Number Susceptible',type='l')
}
\references{
See e.g. Keeling and Rohani 2008 for SIR models and the
  documentation for the deSolve package for details on ODE solvers
}
\seealso{
The UI of the shiny app 'IDPatterns', which is part of this package, contains more details on the model
}
\author{
Andreas Handel
}
