% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{Density-class}
\alias{Density-class}
\alias{add.hotspot,Density-method}
\alias{plot,Density,ANY-method}
\alias{plot,Density-method}
\title{Class "Density"}
\usage{
\S4method{plot}{Density,ANY}(x, y, add = FALSE, plot.units = character(0),
  ...)
}
\arguments{
\item{x}{the coordinates of points in the plot. Alternatively, a
      single plotting structure, function or \emph{any \R object with a
        \code{plot} method} can be provided.}

\item{y}{the y coordinates of points in the plot, \emph{optional}
    if \code{x} is an appropriate structure.}
    
\item{add}{when implemented allows multiple object to be added
    over the top of the existing plot}
  
\item{plot.units}{allows the plot to have different units than 
    the region or density object ('m' or 'km')}

\item{...}{Arguments to be passed to methods, such as
    \link{graphical parameters} (see \code{\link{par}}).
    Many methods will accept the following arguments:
    \describe{
    \item{\code{type}}{what type of plot should be drawn.  Possible types are
      \itemize{
        \item \code{"p"} for \bold{p}oints,
        \item \code{"l"} for \bold{l}ines,
        \item \code{"b"} for \bold{b}oth,
        \item \code{"c"} for the lines part alone of \code{"b"},
        \item \code{"o"} for both \sQuote{\bold{o}verplotted},
        \item \code{"h"} for \sQuote{\bold{h}istogram} like (or
        \sQuote{high-density}) vertical lines,
        \item \code{"s"} for stair \bold{s}teps,
        \item \code{"S"} for other \bold{s}teps, see \sQuote{Details} below,
        \item \code{"n"} for no plotting.
      }
      All other \code{type}s give a warning or an error; using, e.g.,
      \code{type = "punkte"} being equivalent to \code{type = "p"} for S
      compatibility.  Note that some methods,
      e.g. \code{\link{plot.factor}}, do not accept this.
    }
    \item{\code{main}}{an overall title for the plot: see \code{\link{title}}.}
    \item{\code{sub}}{a sub title for the plot: see \code{\link{title}}.}
    \item{\code{xlab}}{a title for the x axis: see \code{\link{title}}.}
    \item{\code{ylab}}{a title for the y axis: see \code{\link{title}}.}
    \item{\code{asp}}{the \eqn{y/x} aspect ratio,
      see \code{\link{plot.window}}.}
    }
  }
}
\description{
Class \code{"Density"} is an S4 class containing a list of grids which
describe the density of individuals / clusters of a population. The list
contains one grid (\code{data.frame}) for each strata.
}
\section{Slots}{

\describe{
 \item{\code{region.name}}{Object of class \code{"character"}; the region
 name.}
 \item{\code{strata.name}}{Object of class \code{"character"}; the strata
 names}
 \item{\code{density.surface}}{Object of class \code{"list"}; list of
 data.frames with the columns x, y and density. There must be one
 data.frame for each strata.}
 \item{\code{x.space}}{Object of class \code{"numeric"}; The spacing
 between gridpoints described in the density data.frames in the
 x-direction.}
 \item{\code{y.space}}{Object of class \code{"numeric"}; The spacing
 between gridpoints described in the density data.frames in the
 y-direction.}
 \item{\code{units}}{Object of class \code{"numeric"}; The units of the
 grid points.}
}
}

\section{Methods}{

\describe{
 \item{\code{add.hotspot}}{\code{signature=(object = "Density")}: adds a hotspot based on a gaussian decay to the density
 surfaces.}
}
}
\seealso{
\code{\link{make.density}}
}
\keyword{classes}

