% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.functions.R, R/DDF.Analysis.R,
%   R/Simulation.R
\name{run.analysis}
\alias{run.analysis}
\alias{run.analysis,DDF.Analysis,DDF.Data-method}
\alias{run.analysis,Simulation,Survey.Results-method}
\alias{run.analysis,Simulation,DDF.Data-method}
\title{S4 generic method to run analyses}
\usage{
run.analysis(object, data, ...)

\S4method{run.analysis}{DDF.Analysis,DDF.Data}(object, data, dht = FALSE, point = FALSE, warnings = list())

\S4method{run.analysis}{Simulation,Survey.Results}(object, data, dht = FALSE)

\S4method{run.analysis}{Simulation,DDF.Data}(object, data, dht = FALSE)
}
\arguments{
\item{object}{an object of class Simulation or DDF.Analysis}

\item{data}{an object of class Survey.Results or DDF.Data}

\item{...}{optional arguments including the following:}

\item{dht}{logical whether density should be estimated after fitting the model}

\item{point}{logical indicating whether it is a point transect survey}

\item{warnings}{a list of warnings and how many times they arose}
}
\value{
a list containing an S3 ddf object and optionally an S3 dht object relating to the model with the minimum criteria.
}
\description{
This method carries out an analysis of distance sampling data. This method
is provided to allow the user to perform diagnostics of the analyses used
in the simulation. The data argument can be obtained by a call to
\code{simulate.survey(object, dht.table = TRUE)}. Note if the first object
supplied is of class DDf.Analysis then the second argument must be of class
DDf.Data. The data argument may be of either class for an object argument
of class Simulation.
}
