% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{setCols.DTSg}
\alias{setCols.DTSg}
\alias{setCols}
\alias{set}
\title{Set column values}
\usage{
\method{setCols}{DTSg}(
  x,
  i,
  cols = self$cols(class = "numeric")[1L],
  values,
  clone = getOption("DTSgClone"),
  ...
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{i}{An integerish vector indexing rows (positive numbers pick and
negative numbers omit rows) or a filter expression accepted by the \code{i}
argument of \code{\link[data.table:data.table]{data.table::data.table}}. Filter expressions can contain the
special symbol \code{\link[data.table:special-symbols]{.N}}.}

\item{cols}{A character vector specifying the columns whose values shall be
set. The values of the \emph{.dateTime} column cannot be changed.}

\item{values}{A vector, \code{\link{list}} or list-like object (e.g.
\code{\link[data.table:data.table]{data.table::data.table}}) of replacement and/or new values accepted by
the \code{value} argument of \pkg{data.table}'s \code{\link[data.table:assign]{data.table::set}} function.
\code{NULL} as a value removes a column.}

\item{clone}{A logical specifying if the object shall be modified in place or
if a deep clone (copy) shall be made beforehand.}

\item{...}{Not used (S3 method only).}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Changes the values of columns, adds columns to and/or removes columns from a
\code{\link{DTSg}} object. The values can optionally be set for certain rows only.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# cap river flows to 100
## R6 method
x$setCols(
  i = flow > 100,
  cols = "flow",
  values = 100
)$print()

## S3 method
print(setCols(
  x = x,
  i = flow > 100,
  cols = "flow",
  values = 100
))

}
\seealso{
\code{\link{cols}}, \code{\link{getOption}}
}
