% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp3.R
\name{Chp3}
\alias{Chp3}
\alias{addProbs}
\alias{predictive_value}
\title{Chapter 3}
\usage{
addProbs(A)

predictive_value(
  A,
  sensitivity = A[1, 1]/sum(A[, 1]),
  specificity = A[2, 2]/sum(A[, 2]),
  prevalence
)
}
\arguments{
\item{A}{\link[base]{matrix} of contingency table.
In \code{\link{predictive_value}}, this must be a 2-by-2 contingency table.}

\item{sensitivity}{\link[base]{numeric} scalar, sensitivity of a test}

\item{specificity}{\link[base]{numeric} scalar, specificity of a test}

\item{prevalence}{(optional) \link[base]{numeric} scalar, prevalence of a disease}
}
\value{
\code{\link{addProbs}} prints the joint, marginal and conditional probabilities of a \link[base]{matrix}. No value is returned.

\code{\link{predictive_value}} returns the sensitivity and specificity of a test, 
based on the 2-by-2 test-disease contingency table.
If the disease prevalence is provided, the predictive values will also be provided.
}
\description{
Functions for Chapter 3, \emph{Some Basic Probability Concepts} of Wayne W. Daniel's 
\emph{Biostatistics: A Foundation for Analysis in the Health Sciences}, Tenth Edition.
}
\examples{
# Page 69, Example 3.4.1
(d341 = matrix(c(28L, 19L, 41L, 53L, 35L, 38L, 44L, 60L), ncol = 2L, 
 dimnames = list(
   FamilyHx = c('none', 'Bipolar', 'Unipolar', 'UniBipolar'), 
   Onset = c('Early', 'Late'))))
class(d341) # 'matrix', i.e., a two-dimensional array
addProbs(d341)

# Page 81, Example 3.5.1
(d351 = matrix(c(436L, 14L, 5L, 495L), nrow = 2L, 
  dimnames = list(Test = c('Positive', 'Negative'), Alzheimer = c('Yes', 'No'))))
predictive_value(d351, prevalence = .113)

}
\references{
Wayne W. Daniel, \emph{Biostatistics: A Foundation for Analysis in the Health Sciences}, Tenth Edition.
Wiley, ISBN: 978-1-119-62550-6.
}
