% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addProbs_vanilla.R
\name{addProbs}
\alias{addProbs}
\title{Add Conditional and/or Marginal Probabilities to an \link[base]{integer} \link[base]{matrix}}
\usage{
addProbs(A, margin = seq_len(nd))
}
\arguments{
\item{A}{\link[base]{matrix} of \link[base]{typeof} \link[base]{integer}, 
two-dimensional contingency table.  See \link[stats]{addmargins}}

\item{margin}{\link[base]{integer} scalar or \link[base]{vector}, see \link[stats]{addmargins}}
}
\value{
Function [addProbs()] returns a \link[base]{noquote} \link[base]{matrix} of subclass `'addedProbs'`.
}
\description{
Add conditional and/or marginal probabilities to a two-way contingency table.
}
\details{
Function [addProbs()] provides the joint, marginal (using `margin = 1:2`) 
and conditional (using `margin = 1L` or `margin = 2L`) 
probabilities of a two-dimensional contingency table.
}
\note{
\link[base]{margin.table} (which is to be renamed as \link[base]{marginSums}) 
is much slower than \link[base]{colSums}.
}
\examples{
(y1 = addProbs(table(warpbreaks$tension)))

storage.mode(WorldPhones) = 'integer'
(y2 = addProbs(WorldPhones))


}
\seealso{
\link[stats]{addmargins} \link[base]{rowSums} \link[base]{colSums} \link[base]{proportions}
}
