% Generated by roxygen2 (4.0.1): do not edit by hand
\name{CountSpell}
\alias{CountSpell}
\title{Count spells, including for grouped data}
\usage{
CountSpell(data, TimeVar = NULL, SpellVar = NULL, GroupVar = NULL,
  NewVar = NULL, SpellValue = NULL)
}
\arguments{
\item{data}{a data frame object.}

\item{TimeVar}{a charachter string naming the time variable.}

\item{SpellVar}{a character string naming the variable with information on
when each spell starts.}

\item{GroupVar}{a character string naming the variable grouping the units
experiencing the spells. If \code{GroupVar = NULL} then .}

\item{NewVar}{NewVar a character string naming the new variable to place the
spell counts in.}

\item{SpellValue}{a value indicating when a unit is in a spell. If
\code{SpellValue = NULL} then any change in \code{Var}'s value will be
treated as the start/end of a spell.}
}
\description{
\code{CountSpell} is a function that returns a variable counting the spell
number for an observation. Works with grouped data.
}
\examples{
# Create fake data
ID <- sort(rep(seq(1:4), 5))
Time <- rep(1:20)
Dummy <-  c(1, sample(c(0, 1), size = 19, replace = TRUE))
Data <- data.frame(ID, Time, Dummy)

# Find spell for whole data frame
DataSpell1 <- CountSpell(Data, TimeVar = 'Time', SpellVar = 'Dummy',
                         SpellValue = 1)

head(DataSpell1)

# Find spell for each ID group
DataSpell2 <- CountSpell(Data, TimeVar = 'Time', SpellVar = 'Dummy',
                         GroupVar = 'ID', SpellValue = 1)

head(DataSpell2)
}

