% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_missing.r
\name{set_missing}
\alias{set_missing}
\alias{SetNaTo}
\title{Set all missing values to indicated value}
\usage{
set_missing(data, value, exclude = NULL)
}
\arguments{
\item{data}{input data, in \link{data.table} format only.}

\item{value}{a single value or a list of two values to be set to. See 'Details'.}

\item{exclude}{column index or name to be excluded.}
}
\description{
Quickly set all missing values to indicated value.
}
\details{
The class of \code{value} will determine what type of columns to be set, e.g., if \code{value} is 0, then missing values for continuous features will be set.
When supplying a list of two values, only one numeric and one non-numeric is allowed.

\bold{This function updates \link{data.table} object directly.} Otherwise, output data will be returned matching input object class.
}
\examples{
# Load packages
library(data.table)

# Generate missing values in iris data
dt <- data.table(iris)
for (j in 1:4) set(dt, i = sample.int(150, j * 30), j, value = NA_integer_)
set(dt, i = sample.int(150, 25), 5L, value = NA_character_)

# Set all missing values to 0L and unknown
dt2 <- copy(dt)
set_missing(dt2, list(0L, "unknown"))

# Set missing numerical values to 0L
dt3 <- copy(dt)
set_missing(dt3, 0L)

# Set missing discrete values to unknown
dt4 <- copy(dt)
set_missing(dt4, "unknown")

# Set missing values excluding some columns
dt5 <- copy(dt)
set_missing(dt4, 0L, 1L:2L)
set_missing(dt4, 0L, names(dt5)[3L:4L])

# Return from non-data.table input
set_missing(airquality, 999999L)
}
\keyword{set_missing}
