% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbExistsTable,DatabaseConnectorConnection,character-method}
\alias{dbExistsTable,DatabaseConnectorConnection,character-method}
\title{Does a table exist?}
\usage{
\S4method{dbExistsTable}{DatabaseConnectorConnection,character}(conn, name,
  database = NULL, schema = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying a DBMS table name.}

\item{database}{Name of the database.}

\item{schema}{Name of the schema.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbExistsTable()} returns a logical scalar, \code{TRUE} if the table or view
specified by the \code{name} argument exists, \code{FALSE} otherwise.
This includes temporary tables if supported by the database.

An error is raised when calling this method for a closed
or invalid connection.
An error is also raised
if \code{name} cannot be processed with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
}
\description{
Returns if a table given by name exists in the database.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbExistsTable")}
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbAppendTable}}, \code{\link{dbCreateTable}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbGetException}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetQuery}},
  \code{\link{dbIsReadOnly}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListObjects}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}},
  \code{\link{dbWriteTable}}
}
