% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbGetRowCount,DatabaseConnectorResult-method}
\alias{dbGetRowCount,DatabaseConnectorResult-method}
\title{The number of rows fetched so far}
\usage{
\S4method{dbGetRowCount}{DatabaseConnectorResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbGetRowCount()} returns a scalar number (integer or numeric),
the number of rows fetched so far.
After calling \code{\link[DBI:dbSendQuery]{dbSendQuery()}},
the row count is initially zero.
After a call to \code{\link[DBI:dbFetch]{dbFetch()}} without limit,
the row count matches the total number of rows returned.
Fetching a limited number of rows
increases the number of rows by the number of rows returned,
even if fetching past the end of the result set.
For queries with an empty result set,
zero is returned
even after fetching.
For data manipulation statements issued with
\code{\link[DBI:dbSendStatement]{dbSendStatement()}},
zero is returned before
and after calling \code{dbFetch()}.
Attempting to get the row count for a result set cleared with
\code{\link[DBI:dbClearResult]{dbClearResult()}} gives an error.
}
\description{
Returns the total number of rows actually fetched with calls to \code{\link[DBI:dbFetch]{dbFetch()}}
for this result set.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbGetRowCount")}
}
\seealso{
Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()},
\code{\link[DBI]{dbUnquoteIdentifier}()}
}
