% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ListTables.R
\name{getTableNames}
\alias{getTableNames}
\title{List all tables in a database schema.}
\usage{
getTableNames(connection, databaseSchema = NULL, cast = "lower")
}
\arguments{
\item{connection}{The connection to the database server created using either
\code{\link[=connect]{connect()}} or \code{\link[=dbConnect]{dbConnect()}}.}

\item{databaseSchema}{The name of the database schema. See details for platform-specific details.}

\item{cast}{Should the table names be cast to uppercase or lowercase before being returned?
Valid options are "upper" , "lower" (default), "none" (no casting is done)}
}
\value{
A character vector of table names.
}
\description{
This function returns a list of all tables in a database schema.
}
\details{
The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.
}
