/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.ArrayList;
import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.ColumnCallException;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.ColumnCall;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.JoinExpression;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.Resolver;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.SourceTable;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import net.starschema.clouddb.jdbc.list.WhereExpressionJoinResolver;
import org.antlr.runtime.tree.Tree;

public class FromExpression
extends Node {
    TreeBuilder builder;
    SelectStatement selectStatement = null;

    public FromExpression(SourceTable sourceTable, TreeBuilder treeBuilder) throws TreeParsingException {
        this.builder = treeBuilder;
        this.tokenType = 50;
        this.tokenName = JdbcGrammarParser.tokenNames[this.tokenType];
        this.children.addLast(sourceTable);
    }

    public FromExpression(Tree t, TreeBuilder treeBuilder, SelectStatement selectStatement) throws TreeParsingException {
        this.selectStatement = selectStatement;
        this.builder = treeBuilder;
        this.build(t, this.builder);
    }

    public FromExpression(TreeBuilder treeBuilder) {
        this.builder = treeBuilder;
    }

    public FromExpression(TreeBuilder builder, JoinExpression joinExpression) {
        this.builder = builder;
        this.children.addLast(joinExpression);
        this.tokenType = 50;
        this.tokenName = JdbcGrammarParser.tokenNames[50];
    }

    public void build(Tree t, TreeBuilder builder) throws TreeParsingException {
        if (t.getType() == 50) {
            this.tokenType = t.getType();
            this.tokenName = JdbcGrammarParser.tokenNames[this.tokenType];
            this.logger.debug("BUILDING " + this.tokenName + " which has " + t.getChildCount() + " child");
            block12: for (int i = 0; i < t.getChildCount(); ++i) {
                Tree child = t.getChild(i);
                switch (child.getType()) {
                    case 124: {
                        Resolver resolve = new Resolver(builder);
                        SourceTable tablenode = new SourceTable(child, builder);
                        String alias = tablenode.getAlias();
                        List<ColumnCall> columnlist = resolve.parseSrcTableForJokers(tablenode);
                        this.logger.debug("got columns");
                        tablenode.alias = null;
                        FromExpression fromexpression = new FromExpression(tablenode, builder);
                        Expression expression = new Expression(columnlist, builder);
                        SelectStatement mySelectStatement = new SelectStatement(expression, fromexpression, builder);
                        expression.setSelectStatement(mySelectStatement);
                        SubQuery mySubQuery = null;
                        if (alias != null) {
                            mySubQuery = new SubQuery(alias, builder, mySelectStatement);
                        } else {
                            String newalias = "";
                            if (tablenode.getDataset() != null) {
                                newalias = newalias + tablenode.getDataset() + ".";
                            }
                            newalias = newalias + tablenode.getName();
                            mySubQuery = new SubQuery(newalias, builder, mySelectStatement);
                        }
                        this.children.addLast(mySubQuery);
                        continue block12;
                    }
                    case 126: {
                        this.children.addLast(new SubQuery(child, builder));
                        continue block12;
                    }
                    case 71: {
                        JoinExpression joinExpression;
                        try {
                            joinExpression = new JoinExpression(child, builder, this.selectStatement);
                        }
                        catch (ColumnCallException e) {
                            throw new TreeParsingException(e);
                        }
                        block13: for (int k = 0; k < child.getChildCount(); ++k) {
                            Tree schild = child.getChild(k);
                            this.logger.debug("SEARCHING MULTIJOINEXPRESSION");
                            switch (schild.getType()) {
                                case 91: {
                                    SubQuery SubQueryFromJoinExpression = WhereExpressionJoinResolver.mkSubQFromJoinExpr(joinExpression, builder, this.selectStatement);
                                    try {
                                        joinExpression = new JoinExpression(SubQueryFromJoinExpression, schild, builder, this.selectStatement);
                                        continue block13;
                                    }
                                    catch (ColumnCallException e) {
                                        throw new TreeParsingException(e);
                                    }
                                }
                            }
                        }
                        SubQuery makeSubQueryFromJoinExpression = WhereExpressionJoinResolver.mkSubQFromJoinExpr(joinExpression, builder, this.selectStatement);
                        this.logger.debug("Printing out SubQuery:\n" + makeSubQueryFromJoinExpression.toPrettyString(1));
                        this.children.addLast(makeSubQueryFromJoinExpression);
                        continue block12;
                    }
                }
            }
        } else {
            throw new TreeParsingException("This Tree is not a FROMEXPRESSION");
        }
    }

    public List<SourceTable> getAllSourceTables() {
        List<SourceTable> sourceTables = this.getSourceTables();
        List<JoinExpression> joinExpressions = this.getJoinExpressions();
        if (joinExpressions != null) {
            for (JoinExpression joinExpression : joinExpressions) {
                Node leftItem = joinExpression.getLeftItem();
                Node rightItem = joinExpression.getRightItem();
                if (leftItem.getTokenType() == 124) {
                    if (sourceTables == null) {
                        sourceTables = new ArrayList<SourceTable>();
                    }
                    sourceTables.add((SourceTable)leftItem);
                }
                if (rightItem.getTokenType() != 124) continue;
                if (sourceTables == null) {
                    sourceTables = new ArrayList<SourceTable>();
                }
                sourceTables.add((SourceTable)rightItem);
            }
        }
        return sourceTables;
    }

    public List<SubQuery> getAllSubQueries() {
        List<SubQuery> subQueries = this.getSubQueries();
        List<JoinExpression> joinExpressions = this.getJoinExpressions();
        if (joinExpressions != null) {
            for (JoinExpression joinExpression : joinExpressions) {
                Node leftItem = joinExpression.getLeftItem();
                Node rightItem = joinExpression.getRightItem();
                if (leftItem.getTokenType() == 126) {
                    if (subQueries == null) {
                        subQueries = new ArrayList<SubQuery>();
                    }
                    subQueries.add((SubQuery)leftItem);
                }
                if (rightItem.getTokenType() != 126) continue;
                if (subQueries == null) {
                    subQueries = new ArrayList<SubQuery>();
                }
                subQueries.add((SubQuery)rightItem);
            }
        }
        return subQueries;
    }

    public List<JoinExpression> getJoinExpressions() {
        return this.getAllinstancesof(JoinExpression.class, 71);
    }

    public List<SourceTable> getSourceTables() {
        return this.getAllinstancesof(SourceTable.class, 124);
    }

    public List<SubQuery> getSubQueries() {
        return this.getAllinstancesof(SubQuery.class, 126);
    }

    @Override
    public String toPrettyString() {
        return this.toPrettyString(-1);
    }

    @Override
    public String toPrettyString(int level) {
        int newlevel = level < 0 ? -1 : level + 1;
        String result = this.tab(level - 1) + " FROM " + newline;
        for (Node node : this.children) {
            result = result + node.toPrettyString(newlevel) + ",";
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }
}

