% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classConstructor.R
\docType{class}
\name{classconstructor}
\alias{classconstructor}
\alias{dsws}
\title{dsws}
\description{
An R5/RC object for accessing the Refinitiv Datastream
  DSWS service.
}
\details{
Creates an R5/RC4 object for accessing the Refinitiv
  Datastream DSWS service
}
\section{Fields}{

\describe{
\item{\code{tokenList}}{fieldDescription}

\item{\code{tokenSource}}{fieldDescription}

\item{\code{serverURL}}{fieldDescription}

\item{\code{username}}{fieldDescription}

\item{\code{password}}{fieldDescription}

\item{\code{initialised}}{fieldDescription}

\item{\code{errorlist}}{fieldDescription}

\item{\code{requestList}}{fieldDescription}

\item{\code{jsonResponseSaveFile}}{fieldDescription}

\item{\code{jsonResponseLoadFile}}{fieldDescription}

\item{\code{dataResponse}}{fieldDescription}

\item{\code{symbolList}}{fieldDescription}

\item{\code{myValues}}{fieldDescription}

\item{\code{myTypes}}{fieldDescription}

\item{\code{logging}}{fieldDescription}

\item{\code{numDatatype}}{fieldDescription}

\item{\code{numInstrument}}{fieldDescription}

\item{\code{numRequests}}{fieldDescription}

\item{\code{numChunks}}{fieldDescription}

\item{\code{chunkLimit}}{fieldDescription}

\item{\code{requestStringLimit}}{fieldDescription}

\item{\code{logFileFolder}}{fieldDescription}
}}

\section{Methods}{

\describe{
\item{\code{initialize(
  dsws.serverURL = "",
  getTokenFunction = NULL,
  token = NULL,
  username = "",
  password = "",
  connect = TRUE
)}}{  initialises the class.
  Unless noConnect is TRUE also connects to the
  Datastream dsws server.

  Authentication can be set in three ways:
  1)  If getTokenFunction is not null then that function is called.  It is expected to
  return a list with items 'TokenValue' and 'TokenExpiry'.

  2)  An access token can also be passed into the class on initialisation, so that it can be shared between sessions.
  'token' is expected to be a list with items 'TokenValue' and 'TokenExpiry'.

  3) A username and password that are used to fetch a token from the DSWS server.  If the username and password are not
  provided, then they are sourced from system enviroment variables (ie Sys.getenv)
      'DatastreamUsername' and 'DatastreamPassword'
  or alternatively (not preferred) then from
          \code{options()$Datastream.Username} and
          \code{options()$Datastream.Password}

    This allows the password to be stored in .Renviron or .RProfile rather
  than in the source code.

  There is a difference in the Refinitiv's documentation about the chunk limit and different accounts have
  different limits.  Some users are limited to 50 items while others are limited to 2000L.  The chunk limit
  can be controlled by setting the chunkLimit parameter of the dsws object.  If     \code{options()$Datastream.ChunkLimit} is
  set then the value is taken from there.

  }

\item{\code{listRequest(instrument, datatype = "", expression = "", requestDate)}}{  Make a listRequest from Datastream DSWS.
  This is the equivalent to
  the Excel static request for a list.

  Parameters are: \describe{
      \item{instrument}{should contain a list mnemonic, such as 'LFTSE100'
      Can be a user created list or index.  The UCL can contain
      expressions}
      \item{datatype}{array of datatypes eg NAME, MNEM, P, PE etc}
      \item{expression}{if datatype is null or '' then an expression
      eg PCH#(XXXX,3M)}
      \item{requestDate}{either a Date or a string with a datastream
      relative date eg '-3M'}
  }
  Returns a data.frame with the requested data.


  Examples:

    \preformatted{
      mydsws$listRequest(instrument = "LFTSE100",
      datatype = c("NAME","P"), 
requestDate = "-0D")
    }
    \preformatted{
      mydsws$listRequest(instrument = "LFTSE100",
      expression = "PCH#(XXXX,3M)", requestDate = Sys.Date())
    }
  }

\item{\code{snapshotRequest(instrument, datatype = "", expression = "", requestDate)}}{  Make a snapshotRequest from Datastream DSWS.
  This is the equivalent
  to the Excel static request for an array of instruments.

  Parameters are: \describe{
  \item{instrument}{should one or more instruments eg "MKS" or
      c("MKS","@AAPL").  The array can contain
      Economics codes and Expressions. }
  \item{datatype}{array of datatypes eg NAME, MNEM, P, PE etc}
  \item{expression}{if datatype is null or '' then an expression
      eg PCH#(XXXX,3M)}
  \item{requestDate}{either a Date or a string with a datastream relative
      date eg '-3M'}
}
  Returns a data.frame with the requested data.


  Examples:

    \preformatted{
  mydsws$snapshotRequest(instrument = c("MKS","@AAPL"), 

   datatype = c("NAME","P"), requestDate = "-0D")
    }
    \preformatted{
  mydsws$snapshotRequest(instrument = c("MKS","@AAPL"), 

   expression = "PCH#(XXXX,3M)", requestDate = "-0D")
    }

  }

\item{\code{timeSeriesListRequest(
  instrument,
  datatype = "",
  expression = "",
  startDate,
  endDate,
  frequency = "D",
  format = "ByInstrument"
)}}{  Make a timeSeriesListRequest from Datastream DSWS.
  This is the
  equivalent to the Excel timeseries request for an array of instruments.
  Should request either a datatype or an expression not both.  If a
  datatype is provided then anything in Expression will be ignored.

  Parameters are: \describe{
  \item{instrument}{should contain a list mnemonic, such as "LFTSE100"
.
  Can be a user created list or index.  The UCL can contain expressions.}
  \item{datatype}{array of datatypes eg P, PE etc}
  \item{expression}{if datatype is null or '' then an expression 

    eg PCH#(XXXX,3M)}
  \item{startDate}{either a Date or a string with a datastream relative date

    eg '-3M'}
  \item{endDate}{either a Date or a string with a datastream relative date 

    eg '-0D'}
  \item{frequency}{one of the standard Datastream frequencies - D, W, M, Q, or Y }
  \item{format}{can be either  "ByInstrument" or "ByDatatype". }
  }
  Returns either a single xts or a list of xts a data.frame with
  the requested data.  If "ByInstrument" then the data is returned as
  one or more (ie a list) wide xts with one column per instrument.
  If "ByDatatype" then the data is returned as one or more (ie a list)
  of wide xts with one column per Datatype.  This format is more compatible
  with the quantmod package.

  Examples:

    \preformatted{
  mydsws$timeSeriesListRequest(instrument = "LFTSE100",

    datatype = "P", startDate = "-30D",

    endDate = "-0D", frequency = "D")
    }
    \preformatted{

  mydsws$timeSeriesListRequest(instrument = "LFTSE100", 

    expression = "PCH#(XXXX,3M)", 

    startDate = "-30D",

    endDate = "-0D", 

    frequency = "D")
    }
    \preformatted{
  mydsws$timeSeriesListRequest(instrument = "LFTSE100", 

    datatype = ("P","UP"), startDate = "-30D",

    endDate = "-0D", 

    frequency = "D", format = "ByDatatype")
}
  }

\item{\code{timeSeriesRequest(
  instrument,
  datatype = "",
  expression = "",
  startDate,
  endDate,
  frequency = "D",
  format = "ByInstrument"
)}}{  Return a timeSeriesRequest from Datastream dsws.
  Should request either
  a datatype or an expression
  not both.  If a datatype is provided then anythink in Expression
  will be ignored

  Make a timeSeriesRequest from Datastream DSWS.  This is the equivalent
  to the Excel timeseries request for an array of instruments.

  Parameters are: \describe{
  \item{instrument}{should one or more instruments eg "MKS" or
   c("MKS","@AAPL").  The array can contain Economics codes and
     Expressions. }
  \item{datatype}{array of datatypes eg P, PE etc}
  \item{expression}{if datatype is null or '' then an expression
  eg PCH#(XXXX,3M)}
  \item{startDate}{either a Date or a string with a datastream relative
  date eg '-3M'}
  \item{endDate}{either a Date or a string with a datastream relative
  date eg '-0D'}
  \item{frequency}{one of the standard Datastream
    frequencies - D, W, M, Q, or Y}
  \item{format}{can be either  "ByInstrument" or "ByDatatype".}
}
  Returns either a single xts or a list of xts a data.frame with
  the requested data.  If "ByInstrument" then
  the data is returned as one or more (ie a list) wide xts with one
  column per instrument.  If "ByDatatype"
  then the data is returned as one or more (ie a list) of wide xts with
  one column per Datatype.  This format
  is more compatible with the quantmod package.

  Examples:

    \preformatted{
  mydsws$timeSeriesRequest(instrument = c("MKS","@AAPL"),

      datatype = "P", startDate = "-30D",

      endDate = "-0D", frequency = "D")
    }
    \preformatted{

  mydsws$timeSeriesRequest(instrument = c("MKS"), 

      expression = "PCH#(XXXX,3M)", startDate = "-30D",

      endDate = "-0D", frequency = "D")
    }
    \preformatted{
  mydsws$timeSeriesRequest(instrument = c("MKS","@AAPL"), 

      datatype = ("P","UP"), startDate = "-30D",

      endDate = "-0D", frequency = "D", format = "ByDatatype")
    }

  }
}}

\examples{
\dontrun{


     mydsws <- dsws$new()
     # Snapshot requests


     myData <- mydsws$snapshotRequest(instrument = c("ABF","RIO","WPP"),
                                      datatype = "P",
                                      requestDate = "0D")

     myData <- mydsws$snapshotRequest(instrument = c("ABF","RIO","WPP"),
                                      expression = "PCH#(XXXX,3M)",
                                      requestDate = "0D")
     myData <- mydsws$listRequest(instrument = "LFTSE100", datatype = "P", requestDate = "0D")

     mydsws$snapshotRequest(instrument = c("SWCNB10","UKEUSCCIR"),
                            datatype = c("MNEM","UPDATE"),
                            requestDate = "0D")
     mydsws$snapshotRequest(instrument = c("VOD", "HSBA"),
                            datatype="QTEALL",
                            requestDate = Sys.Date())
     mydsws$snapshotRequest(instrument = "STATS",
                            datatype = "DS.USERSTATS",
                            requestDate = Sys.Date())


     # Timeseries requests


     xtsData <- mydsws$timeSeriesRequest(instrument = "MKS",
                                         datatype = "MV",
                                         startDate = "-30D",
                                         endDate = "-0D",
                                         frequency = "D")

     xtsData <- mydsws$timeSeriesListRequest(instrument = "LFTSE100",
                                             datatype = "MV",
                                             startDate = "-30D",
                                             endDate = "-0D",
                                             frequency = "D")
}
}
