% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb_functions.R
\name{search_string_db}
\alias{search_string_db}
\title{Search STRING Database}
\usage{
search_string_db(
  genes_list,
  species = 9606,
  network_type = "full",
  score_threshold = 400
)
}
\arguments{
\item{genes_list}{A list of gene IDs.}

\item{species}{The NCBI taxon ID of the species. Defaults to 9606 (Homo sapiens).}

\item{network_type}{The type of network to use, either "full" or "physical". Defaults to "full".}

\item{score_threshold}{The minimum score threshold for string interactions. Defaults to 400.}
}
\value{
A list containing the following elements:
\describe{
\item{string_results}{A data frame with STRING interaction metrics.}
\item{string_db}{The STRINGdb object used.}
\item{string_ids}{The STRING IDs for the input genes.}
}
}
\description{
Search the STRING database for protein interactions.
}
\examples{
\dontrun{
library(STRINGdb)
genes <- c("TP53", "BRCA1")
results <- search_string_db(genes)
print(results)
}
}
