% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_helper_functions.R
\name{post_design}
\alias{post_design}
\alias{print_code}
\title{Explore your design}
\usage{
print_code(design)
}
\arguments{
\item{design}{A design object, typically created using the + operator}
}
\description{
Explore your design

Print code to recreate a design
}
\examples{

design <-
  declare_population(N = 500, noise = rnorm(N)) +
  declare_potential_outcomes(Y ~ noise + Z * rnorm(N, 2, 2)) +
  declare_sampling(n = 250) +
  declare_estimand(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_step(dplyr::mutate, noise_sq = noise^2) +
  declare_assignment(m = 25) +
  declare_reveal() +
  declare_estimator(Y ~ Z, estimand = "my_estimand")

design

df <- draw_data(design)

estimates <- draw_estimates(design)
estimands <- draw_estimands(design)


my_population <- declare_population(N = 100)

my_assignment <- declare_assignment(m = 50)

my_design <- my_population + my_assignment

print_code(my_design)

}
