% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_measurement.R
\name{declare_measurement}
\alias{declare_measurement}
\title{Declare measurement procedure}
\usage{
declare_measurement(..., handler = fabricate, label = NULL)
}
\arguments{
\item{...}{arguments to be captured, and later passed to the handler}

\item{handler}{a tidy-in, tidy-out function}

\item{label}{a string describing the step}
}
\value{
A function that returns a data.frame.
}
\description{
This function adds measured data columns that can be functions of unmeasured data columns.
}
\details{
It is also possible to include measured variables in your declare_population call or to add variables using declare_step. However, putting latent variables in declare_population and variables-as-measured in declare_measurement helps communicate which parts of your research design are in M and which parts are in D.
}
\examples{

design <-
  declare_population(N = 10, latent = seq(0, 1, length.out = N)) +
  declare_measurement(
    observed = as.numeric(cut(latent, breaks = seq(0, 1, length.out = 6), include.lowest = TRUE)))

draw_data(design)

}
