% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oscillate.R
\name{oscillate}
\alias{oscillate}
\title{Modify a signal using a Van der Pol oscillator}
\usage{
oscillate(
  xy,
  dt,
  period,
  delta = 0.05,
  damp = 5e-05,
  f.noise = 5,
  f.signal = 0.95,
  dx = function(x, y, beta, damp) beta * y - x * (x^2 + y^2 - 1) * damp,
  dy = function(x, y, beta, damp) -beta * x - y * (x^2 + y^2 - 1) * damp,
  xi = if (length(xy) != 0) xy[1] else 0.5,
  yi = if (length(xy) != 0) xy[1] else 0.5,
  normalise = TRUE,
  limit = TRUE
)
}
\arguments{
\item{xy}{initial signal (vector or matrix)}

\item{dt}{depth/time (same length than length/rows of xy)}

\item{period}{the period of the oscillator (length 1 or n)}

\item{delta}{the sampling interval for iteration (length 1 or n)}

\item{damp}{damping parameter}

\item{f.noise}{a factor of the amount of noise (length 1 or n)}

\item{f.signal}{a factor of the amount of signal (length 1 or n)}

\item{dx, dy}{the differentials used in the oscillator. They should be
provided as functions needing x, y, beta (2*pi/period) and damp (damping)
parameters}

\item{xi}{the initial x value}

\item{yi}{the initial y value}

\item{normalise}{whether to recenter the output signal on the initial signal}

\item{limit}{whether to warn when parameters are irrealistic (subjective)}
}
\description{
Modify a signal using a Van der Pol oscillator
}
\examples{
set.seed(42)

n <- 800

dt <- seq(0,n, 1)

p1 <- 100
p2 <- 40

xy <- (1 + 0.6 * sin(dt*2*pi/p1)) * sin(dt*2*pi/p2)  + 2 * sin(dt*2*pi/p1) + 1

xyout <- oscillate(xy, dt, period = 30)

opar <- par("mfrow")

par(mfrow = c(1,1))

plot(xy, dt, type = "l",
     main = "Initial signal (bold) & oscillated signal (dashed)",
     lwd = 2, xlim = c(-4, 6))
lines(xyout, dt, type = "l", col = "grey50", lwd = 2, lty = 5)

par(mfrow = opar)

}
