/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class GLMExplorerExport
extends JDialog
implements ActionListener {
    private JPanel residPanel;
    private JPanel predPanel;
    private JPanel okayCancel;
    private JCheckBox pred;
    private JCheckBox hat;
    private JCheckBox dffits;
    private JCheckBox dfbeta;
    private JPanel objectsPanel;
    private JLabel modelNameLabel;
    private JCheckBox keepModel;
    private JTextField modelName;
    private JCheckBox covratio;
    private JCheckBox cooks;
    private JCheckBox linearPred;
    private JCheckBox stResid;
    private JCheckBox sdResid;
    private JCheckBox resid;
    private JPanel diagnosticPanel;
    private GLMModel model;

    public GLMExplorerExport(JFrame jFrame, GLMModel gLMModel) {
        super(jFrame);
        this.initGUI();
        this.setModel(gLMModel);
        this.setModal(true);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.residPanel = new JPanel();
            this.getContentPane().add(this.residPanel);
            this.residPanel.setBounds(12, 12, 173, 100);
            this.residPanel.setBorder(BorderFactory.createTitledBorder("Residuals"));
            this.residPanel.setLayout(null);
            this.resid = new JCheckBox();
            this.residPanel.add(this.resid);
            this.resid.setText("Residuals");
            this.resid.setBounds(17, 20, 139, 19);
            this.sdResid = new JCheckBox();
            this.residPanel.add(this.sdResid);
            this.sdResid.setText("Standardized");
            this.sdResid.setBounds(17, 45, 139, 19);
            this.stResid = new JCheckBox();
            this.residPanel.add(this.stResid);
            this.stResid.setText("Studentized");
            this.stResid.setBounds(17, 70, 139, 19);
            this.predPanel = new JPanel();
            this.getContentPane().add(this.predPanel);
            this.predPanel.setBounds(197, 12, 191, 100);
            this.predPanel.setBorder(BorderFactory.createTitledBorder("Predicted"));
            this.predPanel.setLayout(null);
            this.pred = new JCheckBox();
            this.predPanel.add(this.pred);
            this.pred.setText("Response");
            this.pred.setBounds(17, 20, 127, 19);
            this.linearPred = new JCheckBox();
            this.predPanel.add(this.linearPred);
            this.linearPred.setText("Linear");
            this.linearPred.setBounds(17, 45, 127, 19);
            this.diagnosticPanel = new JPanel();
            this.getContentPane().add(this.diagnosticPanel);
            this.diagnosticPanel.setBounds(12, 118, 376, 101);
            this.diagnosticPanel.setBorder(BorderFactory.createTitledBorder("Diagnostics"));
            this.diagnosticPanel.setLayout(null);
            this.cooks = new JCheckBox();
            this.diagnosticPanel.add(this.cooks);
            this.cooks.setText("Cooks Distance");
            this.cooks.setBounds(17, 20, 148, 19);
            this.dfbeta = new JCheckBox();
            this.diagnosticPanel.add(this.dfbeta);
            this.dfbeta.setText("DFBETA");
            this.dfbeta.setBounds(17, 45, 148, 19);
            this.dffits = new JCheckBox();
            this.diagnosticPanel.add(this.dffits);
            this.dffits.setText("DFFITS");
            this.dffits.setBounds(17, 70, 148, 19);
            this.hat = new JCheckBox();
            this.diagnosticPanel.add(this.hat);
            this.hat.setText("Hat");
            this.hat.setBounds(171, 20, 148, 19);
            this.covratio = new JCheckBox();
            this.diagnosticPanel.add(this.covratio);
            this.covratio.setText("Cov Ratio");
            this.covratio.setBounds(171, 45, 188, 19);
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancel);
            this.okayCancel.setBounds(180, 297, 208, 35);
            this.objectsPanel = new JPanel();
            this.getContentPane().add(this.objectsPanel);
            this.objectsPanel.setBounds(42, 219, 279, 72);
            this.objectsPanel.setBorder(BorderFactory.createTitledBorder("Objects"));
            this.objectsPanel.setLayout(null);
            this.modelNameLabel = new JLabel();
            this.objectsPanel.add(this.modelNameLabel);
            this.modelNameLabel.setText("Model Name:");
            this.modelNameLabel.setBounds(17, 25, 103, 15);
            this.modelNameLabel.setHorizontalAlignment(4);
            this.modelName = new JTextField();
            this.objectsPanel.add(this.modelName);
            this.modelName.setText("<auto>");
            this.modelName.setBounds(120, 21, 142, 22);
            this.keepModel = new JCheckBox();
            this.objectsPanel.add(this.keepModel);
            this.keepModel.setText("Keep");
            this.keepModel.setBounds(120, 43, 106, 19);
            this.setTitle("Save Objects");
            this.setSize(400, 366);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateModel() {
        this.model.export.resid = this.resid.isSelected();
        this.model.export.sdresid = this.sdResid.isSelected();
        this.model.export.stresid = this.stResid.isSelected();
        this.model.export.pred = this.pred.isSelected();
        this.model.export.linearPred = this.linearPred.isSelected();
        this.model.export.cooks = this.cooks.isSelected();
        this.model.export.dfbeta = this.dfbeta.isSelected();
        this.model.export.dffits = this.dffits.isSelected();
        this.model.export.hats = this.hat.isSelected();
        this.model.export.covratio = this.covratio.isSelected();
        this.model.export.keepModel = this.keepModel.isSelected();
        this.model.export.modelName = this.modelName.getText();
    }

    public void setModel(GLMModel gLMModel) {
        this.model = gLMModel;
        this.resid.setSelected(this.model.export.resid);
        this.sdResid.setSelected(this.model.export.sdresid);
        this.stResid.setSelected(this.model.export.stresid);
        this.pred.setSelected(this.model.export.pred);
        this.linearPred.setSelected(this.model.export.linearPred);
        this.cooks.setSelected(this.model.export.cooks);
        this.dfbeta.setSelected(this.model.export.dfbeta);
        this.dffits.setSelected(this.model.export.dffits);
        this.hat.setSelected(this.model.export.hats);
        this.covratio.setSelected(this.model.export.covratio);
        this.keepModel.setSelected(this.model.export.keepModel);
        this.modelName.setText(this.model.export.modelName);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel") {
            this.dispose();
        } else if (string == "OK") {
            this.updateModel();
            this.dispose();
        }
    }

    public void setSinglePredicted() {
        this.linearPred.setVisible(false);
        this.pred.setText("Predicted");
    }
}

