% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_spending.ds.R
\name{open_spending.ds}
\alias{open_spending.ds}
\title{Read and Calculate the Basic Information for Basic Descriptive Tasks from Open Spending and Rudolf APIs.}
\usage{
open_spending.ds(json_data, dimensions=NULL, amounts=NULL, measured.dimensions=NULL, 
coef.outl=1.5, box.outliers=T, box.wdth=0.15,
cor.method= "pearson", freq.select=NULL)
}
\arguments{
\item{json_data}{The json string, URL or file from Open Spending API}

\item{dimensions}{The dimensions of the input data}

\item{amounts}{The measures of the input data}

\item{measured.dimensions}{The dimensions to which correspond amount/numeric variables}

\item{coef.outl}{Determines the length of the "whiskers" plot.
If it is equal to zero no outliers will be returned.}

\item{box.outliers}{If TRUE the outliers will be computed at the selected "coef.outl" level 
(default is 1.5 times the Interquartile Range).}

\item{box.wdth}{The width level is determined 0.15 times the square root of the size of the input data.}

\item{cor.method}{The correlation coefficient method to compute: "pearson" (default),
"kendall" or "spearman".}

\item{freq.select}{One or more nominal variables to calculate their corresponding frequencies.}
}
\value{
A json string with the resulted parameters of the \code{\link{ds.analysis}} function.
}
\description{
Extract and analyze the input data provided from Open Spending API, using the ds.analysis function.
}
\details{
This function is used to read data in json format from Open Spending and Rudolf APIs., in order to implement 
some basic descriptive tasks through \code{\link{ds.analysis}} function.
}
\examples{
# OpenBudgets.eu Dataset Example:
#data=Wuppertal_openspending
#open_spending.ds(data, dimensions ="functional_classification_3.Produktgruppe|date_2.Year",
  #              amounts = "Amount")
                
}
\seealso{
\code{\link{ds.analysis}}
}
\author{
Kleanthis Koupidis
}
