% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peelingOne.R
\name{peelingOne}
\alias{peelingOne}
\title{A Function to Apply the Peeling Algorithm in a Single Copy Number Matrix}
\usage{
peelingOne(X, posDT, k, threshold = NULL)
}
\arguments{
\item{X}{A matrix of normalized gene-level copy number data (rows = genes, columns = subjects).}

\item{posDT}{A data frame containing genomic position information for the genes in X.}

\item{k}{The location (row of X) containing the peak that will be peeled.}

\item{threshold}{A tuning parameter that controls the size of the peeled region.  Rows of X

with mean copy number less than threshold will not be peeled.}
}
\value{
A list containing two elements: X and interval.  X is an updated version of the input
copy number matrix in which the peak at k has been removed, and interval is genomic region
containing k.  By construction, interval cannot extend beyond the chromosome arm containing k.
}
\description{
This function applies the peeling algorithm, as described in Walter et al. (PMID  21183584),
}
\details{
to remove a peak from a copy number data set and define a genomic interval of interest around

the peak.
}
\examples{
lusc=pD[["X"]]

 posDT=pD[["posDT"]]

 kLusc=which.max(rowMeans(lusc))

 peeledLusc=peelingOne(X=lusc,posDT=posDT,k=kLusc,threshold=NULL)   

}
